/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft.util;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.minecraft.world.ChunkCoordIntPair;

public class Packet {

    public static class UpdateBlockMessage
    implements IMessage {
        public int key;
        public byte[] value;

        public void fromBytes(ByteBuf buf) {
            this.key = buf.readInt();
            this.value = new byte[buf.readableBytes()];
            buf.readBytes(this.value);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.key);
            buf.writeBytes(this.value);
        }
    }

    public static class FetchChunkResponse
    implements IMessage {
        ChunkCoordIntPair chunk;
        public ByteBuffer data;

        public void fromBytes(ByteBuf buf) {
            int x = buf.readInt();
            int z = buf.readInt();
            this.chunk = new ChunkCoordIntPair(x, z);
            this.data = ByteBuffer.allocate(buf.readableBytes());
            buf.readBytes(this.data);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
            buf.writeBytes(this.data);
        }
    }

    public static class FetchChunkRequest
    implements IMessage {
        ChunkCoordIntPair chunk;

        public void fromBytes(ByteBuf buf) {
            int x = buf.readInt();
            int z = buf.readInt();
            this.chunk = new ChunkCoordIntPair(x, z);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
        }
    }
}

