/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;
import uk.co.stealthware.minecraft.util.HPMSEventHandler;
import uk.co.stealthware.minecraft.util.Packet;
import uk.co.stealthware.minecraft.util.PacketHandler;

public class HighPerformanceMetadataStore {
    static HighPerformanceMetadataStore instance;
    String modid;
    String name;
    int size;
    CachePreloadMode cacheMode;
    byte[] defaultData;
    Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap;
    List<ChunkCoordIntPair> dirtyChunks;
    File dataFile;
    SimpleNetworkWrapper network;

    public HighPerformanceMetadataStore(String modid, String name) {
        this(modid, name, 2);
    }

    public HighPerformanceMetadataStore(String modid, String name, int size) {
        this(modid, name, size, CachePreloadMode.ActiveChunks);
    }

    public HighPerformanceMetadataStore(String modid, String name, int size, CachePreloadMode cacheMode) {
        instance = this;
        this.modid = modid;
        this.name = name;
        this.size = size;
        this.cacheMode = cacheMode;
        this.defaultData = new byte[size];
        HPMSEventHandler eventHandler = new HPMSEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.network = new SimpleNetworkWrapper("Stealthware_HPMS_C1");
        this.network.registerMessage(PacketHandler.FetchChunkRequestHandler.class, Packet.FetchChunkRequest.class, 1, Side.SERVER);
        this.network.registerMessage(PacketHandler.FetchChunkResponseHandler.class, Packet.FetchChunkResponse.class, 2, Side.CLIENT);
        this.network.registerMessage(PacketHandler.UpdateBlockMessageServerHandler.class, Packet.UpdateBlockMessage.class, 3, Side.SERVER);
        this.network.registerMessage(PacketHandler.UpdateBlockMessageClientHandler.class, Packet.UpdateBlockMessage.class, 4, Side.CLIENT);
    }

    public void setDefault(byte data) {
        byte[] bytes = new byte[]{data};
        this.setDefault(bytes);
    }

    public void setDefault(short data) {
        byte[] bytes = ByteBuffer.allocate(2).putShort(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(int data) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(long data) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(byte[] data) {
        this.defaultData = data;
    }

    public void set(int blockX, int blockY, int blockZ, byte data) {
        byte[] bytes = new byte[]{data};
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, short data) {
        byte[] bytes = ByteBuffer.allocate(2).putShort(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, int data) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, long data) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, byte[] data) {
        this.setData(blockX / 16, blockZ / 16, blockX % 16, blockZ % 16, blockY, data);
    }

    public byte getByte(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return bytes[0];
    }

    public short getShort(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getShort();
    }

    public int getInt(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getInt();
    }

    public long getLong(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getLong();
    }

    public byte[] get(int blockX, int blockY, int blockZ) {
        return this.getData(blockX / 16, blockZ / 16, blockX % 16, blockZ % 16, blockY);
    }

    void init(File worldDir) {
        this.chunkMap = new HashMap<ChunkCoordIntPair, Map<Short, byte[]>>();
        this.dirtyChunks = new ArrayList<ChunkCoordIntPair>();
        this.dataFile = new File(worldDir, this.modid + "-" + this.name + ".hpms");
    }

    void uninit() {
        this.flushAll();
        this.chunkMap = null;
        this.dirtyChunks = null;
    }

    void flushAll() {
        if (this.chunkMap == null) {
            return;
        }
        for (ChunkCoordIntPair chunk : this.dirtyChunks) {
            this.flushChunk(chunk);
        }
    }

    void flushChunk(ChunkCoordIntPair chunk) {
    }

    void initChunk(ChunkCoordIntPair chunk) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (!this.chunkMap.containsKey(chunk)) {
            HashMap blockMap = new HashMap();
            if (side != Side.SERVER) {
                Packet.FetchChunkRequest request = new Packet.FetchChunkRequest();
                request.chunk = chunk;
                this.network.sendToServer((IMessage)request);
            }
            this.chunkMap.put(chunk, blockMap);
        }
    }

    void removeChunk(ChunkCoordIntPair chunk) {
        this.chunkMap.remove(chunk);
    }

    private void setData(int chunkX, int chunkZ, int blockX, int blockZ, int blockY, byte[] data) {
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
        short key = this.createKey(blockX, blockZ, blockY);
        this.chunkMap.get(chunk).put(key, data);
        this.dirtyChunks.add(chunk);
    }

    private byte[] getData(int chunkX, int chunkZ, int blockX, int blockZ, int blockY) {
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
        short key = this.createKey(blockX, blockZ, blockY);
        byte[] val = this.chunkMap.get(chunk).get(key);
        if (val == null) {
            return this.defaultData;
        }
        return val;
    }

    public Packet.FetchChunkResponse sendChunkToClient(Packet.FetchChunkRequest message) {
        Map<Short, byte[]> blockMap = this.chunkMap.get(message.chunk);
        Packet.FetchChunkResponse response = new Packet.FetchChunkResponse();
        response.chunk = message.chunk;
        response.data = this.convertChunkToBytes(blockMap);
        return response;
    }

    public void receiveChunkFromServer(Packet.FetchChunkResponse message) {
        Map<Short, byte[]> blockMap = this.convertBytesToChunk(message.data);
        this.chunkMap.put(message.chunk, blockMap);
    }

    private short createKey(int blockX, int blockZ, int blockY) {
        int key = blockX << 12;
        key |= blockZ << 8;
        return (short)(key |= blockY);
    }

    private ByteBuffer convertChunkToBytes(Map<Short, byte[]> blockMap) {
        int bufferSize = (2 + this.size) * blockMap.size();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (Map.Entry<Short, byte[]> item : blockMap.entrySet()) {
            buffer.putShort(item.getKey());
            buffer.put(item.getValue());
        }
        return buffer;
    }

    private Map<Short, byte[]> convertBytesToChunk(ByteBuffer buffer) {
        int blockCount = buffer.capacity() / (2 + this.size);
        HashMap<Short, byte[]> blockMap = new HashMap<Short, byte[]>(blockCount);
        for (int i = 0; i < blockCount; ++i) {
            short key = buffer.getShort();
            byte[] value = new byte[this.size];
            buffer.get(value);
            blockMap.put(key, value);
        }
        return blockMap;
    }

    public static enum CachePreloadMode {
        Everything,
        ActiveChunks,
        Nothing;

    }
}

