/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft.hpms;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.minecraft.world.ChunkCoordIntPair;

public class Packet {

    public static class UpdateBlockMessage
    implements IMessage {
        public int valueId;
        public ChunkCoordIntPair chunk;
        public short key;
        public byte[] data;

        public UpdateBlockMessage() {
        }

        public UpdateBlockMessage(int valueId, ChunkCoordIntPair chunk, short key, byte[] data) {
            this.valueId = valueId;
            this.chunk = chunk;
            this.key = key;
            this.data = data;
        }

        public void fromBytes(ByteBuf buf) {
            this.valueId = buf.readInt();
            int x = buf.readInt();
            int z = buf.readInt();
            this.chunk = new ChunkCoordIntPair(x, z);
            this.key = buf.readShort();
            this.data = new byte[buf.readableBytes()];
            buf.readBytes(this.data);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.valueId);
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
            buf.writeShort((int)this.key);
            buf.writeBytes(this.data);
        }
    }

    public static class FetchChunkResponse
    implements IMessage {
        public int valueId;
        public ChunkCoordIntPair chunk;
        public ByteBuffer data;

        public FetchChunkResponse() {
        }

        public FetchChunkResponse(int valueId, ChunkCoordIntPair chunk, ByteBuffer data) {
            this.valueId = valueId;
            this.chunk = chunk;
            this.data = data;
        }

        public void fromBytes(ByteBuf buf) {
            this.valueId = buf.readInt();
            int x = buf.readInt();
            int z = buf.readInt();
            this.chunk = new ChunkCoordIntPair(x, z);
            this.data = ByteBuffer.allocate(buf.readableBytes());
            buf.readBytes(this.data);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.valueId);
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
            buf.writeBytes(this.data);
        }
    }

    public static class FetchChunkRequest
    implements IMessage {
        public int valueId;
        public ChunkCoordIntPair chunk;

        public FetchChunkRequest() {
        }

        public FetchChunkRequest(int valueId, ChunkCoordIntPair chunk) {
            this.valueId = valueId;
            this.chunk = chunk;
        }

        public void fromBytes(ByteBuf buf) {
            this.valueId = buf.readInt();
            int x = buf.readInt();
            int z = buf.readInt();
            this.chunk = new ChunkCoordIntPair(x, z);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.valueId);
            buf.writeInt(this.chunk.field_77276_a);
            buf.writeInt(this.chunk.field_77275_b);
        }
    }
}

