/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft.hpms;

import java.nio.ByteBuffer;
import uk.co.stealthware.minecraft.hpms.HighPerformanceMetadataStore;

public class HpmsValue {
    String modid;
    String name;
    int size;
    HighPerformanceMetadataStore.CachePreloadMode cacheMode;
    byte[] defaultData;

    public HpmsValue(String modid, String name) {
        this(modid, name, 2);
    }

    public HpmsValue(String modid, String name, int size) {
        this(modid, name, size, HighPerformanceMetadataStore.CachePreloadMode.ActiveChunks);
    }

    public HpmsValue(String modid, String name, int size, HighPerformanceMetadataStore.CachePreloadMode cacheMode) {
        this.modid = modid;
        this.name = name;
        this.size = size;
        this.cacheMode = cacheMode;
        this.defaultData = new byte[size];
    }

    public void setDefault(byte data) {
        byte[] bytes = new byte[]{data};
        this.setDefault(bytes);
    }

    public void setDefault(short data) {
        byte[] bytes = ByteBuffer.allocate(2).putShort(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(int data) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(long data) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(data).array();
        this.setDefault(bytes);
    }

    public void setDefault(byte[] data) {
        this.defaultData = data;
    }

    public void set(int blockX, int blockY, int blockZ, byte data) {
        byte[] bytes = new byte[]{data};
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, short data) {
        byte[] bytes = ByteBuffer.allocate(2).putShort(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, int data) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, long data) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(data).array();
        this.set(blockX, blockY, blockZ, bytes);
    }

    public void set(int blockX, int blockY, int blockZ, byte[] data) {
        HighPerformanceMetadataStore.instance.setData(this, blockX / 16, blockZ / 16, blockX % 16, blockZ % 16, blockY, data);
    }

    public byte getByte(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return bytes[0];
    }

    public short getShort(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getShort();
    }

    public int getInt(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getInt();
    }

    public long getLong(int blockX, int blockY, int blockZ) {
        byte[] bytes = this.get(blockX, blockY, blockZ);
        return ByteBuffer.wrap(bytes).getLong();
    }

    public byte[] get(int blockX, int blockY, int blockZ) {
        byte[] val = HighPerformanceMetadataStore.instance.getData(this, blockX / 16, blockZ / 16, blockX % 16, blockZ % 16, blockY);
        if (val == null) {
            return this.defaultData;
        }
        return val;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modid == null ? 0 : this.modid.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HpmsValue other = (HpmsValue)obj;
        if (this.modid == null ? other.modid != null : !this.modid.equals(other.modid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.size == other.size;
    }
}

