/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft.hpms;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.MinecraftForge;
import uk.co.stealthware.minecraft.hpms.EventHandler;
import uk.co.stealthware.minecraft.hpms.HpmsValue;
import uk.co.stealthware.minecraft.hpms.Packet;
import uk.co.stealthware.minecraft.hpms.PacketHandler;

public class HighPerformanceMetadataStore {
    static HighPerformanceMetadataStore instance;
    Map<Integer, HpmsValue> values = new HashMap<Integer, HpmsValue>();
    Map<HpmsValue, Map<ChunkCoordIntPair, Map<Short, byte[]>>> valueMap = new HashMap<HpmsValue, Map<ChunkCoordIntPair, Map<Short, byte[]>>>();
    Map<HpmsValue, List<ChunkCoordIntPair>> dirtyChunks = new HashMap<HpmsValue, List<ChunkCoordIntPair>>();
    Map<String, File> dataFiles = new HashMap<String, File>();
    SimpleNetworkWrapper network;

    private HighPerformanceMetadataStore() {
        EventHandler eventHandler = new EventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.network = new SimpleNetworkWrapper("Stealthware_HPMS_C1");
        this.network.registerMessage(PacketHandler.FetchChunkRequestHandler.class, Packet.FetchChunkRequest.class, 1, Side.SERVER);
        this.network.registerMessage(PacketHandler.FetchChunkResponseHandler.class, Packet.FetchChunkResponse.class, 2, Side.CLIENT);
        this.network.registerMessage(PacketHandler.UpdateBlockMessageServerHandler.class, Packet.UpdateBlockMessage.class, 3, Side.SERVER);
        this.network.registerMessage(PacketHandler.UpdateBlockMessageClientHandler.class, Packet.UpdateBlockMessage.class, 4, Side.CLIENT);
    }

    public static void register(HpmsValue value) {
        if (instance == null) {
            instance = new HighPerformanceMetadataStore();
        }
        HighPerformanceMetadataStore.instance.values.put(value.hashCode(), value);
    }

    void init(File worldDir) {
        for (HpmsValue value : this.values.values()) {
            if (!this.dataFiles.containsKey(value.modid)) {
                this.dataFiles.put(value.modid, new File(worldDir, "data" + File.pathSeparator + "HPMS_" + value.modid + ".dat"));
            }
            this.valueMap.put(value, new HashMap());
            this.dirtyChunks.put(value, new ArrayList());
        }
    }

    void uninit() {
        this.flushAll();
        this.dataFiles.clear();
        this.valueMap.clear();
        this.dirtyChunks.clear();
    }

    void flushAll() {
        for (Map.Entry<HpmsValue, List<ChunkCoordIntPair>> item : this.dirtyChunks.entrySet()) {
            for (ChunkCoordIntPair chunk : item.getValue()) {
                this.flushChunk(item.getKey(), chunk);
            }
        }
    }

    void flushChunk(ChunkCoordIntPair chunk) {
        for (HpmsValue value : this.valueMap.keySet()) {
            this.flushChunk(value, chunk);
        }
    }

    void flushChunk(HpmsValue value, ChunkCoordIntPair chunk) {
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(chunk);
        if (!blockMap.isEmpty()) {
            System.out.println("saving chunk: " + chunk.toString());
            try {
                File file = this.dataFiles.get(value.modid);
                NBTTagCompound fileTag = CompressedStreamTools.func_74797_a((File)file);
                if (fileTag == null) {
                    fileTag = new NBTTagCompound();
                }
                NBTTagCompound valueTag = new NBTTagCompound();
                valueTag.func_74778_a("Name", value.name);
                valueTag.func_74768_a("Size", value.size);
                ByteBuffer data = this.convertChunkToBytes(blockMap, value.size);
                NBTTagCompound chunkTag = new NBTTagCompound();
                chunkTag.func_74768_a("ChunkX", chunk.field_77276_a);
                chunkTag.func_74768_a("ChunkZ", chunk.field_77275_b);
                chunkTag.func_74773_a("Data", data.array());
                NBTTagList chunkList = new NBTTagList();
                chunkList.func_74742_a((NBTBase)chunkTag);
                valueTag.func_74782_a("Chunks", (NBTBase)chunkList);
                NBTTagList valueList = new NBTTagList();
                valueList.func_74742_a((NBTBase)valueTag);
                fileTag.func_74782_a("Values", (NBTBase)valueList);
                CompressedStreamTools.func_74795_b((NBTTagCompound)fileTag, (File)file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void initChunk(ChunkCoordIntPair chunk) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        for (Map.Entry<HpmsValue, Map<ChunkCoordIntPair, Map<Short, byte[]>>> item : this.valueMap.entrySet()) {
            Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = item.getValue();
            if (chunkMap.containsKey(chunk) || side == Side.SERVER) continue;
            Packet.FetchChunkRequest request = new Packet.FetchChunkRequest(item.getKey().hashCode(), chunk);
            this.network.sendToServer((IMessage)request);
        }
    }

    void removeChunk(ChunkCoordIntPair chunk) {
        for (Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap : this.valueMap.values()) {
            chunkMap.remove(chunk);
        }
    }

    void setData(HpmsValue value, int chunkX, int chunkZ, int blockX, int blockZ, int blockY, byte[] data) {
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
        short key = this.createKey(blockX, blockZ, blockY);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(chunk);
        if (blockMap == null) {
            blockMap = new HashMap<Short, byte[]>();
            chunkMap.put(chunk, blockMap);
        }
        blockMap.put(key, data);
        Packet.UpdateBlockMessage update = new Packet.UpdateBlockMessage(value.hashCode(), chunk, key, data);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            if (!this.dirtyChunks.get(value).contains(chunk)) {
                this.dirtyChunks.get(value).add(chunk);
            }
            this.network.sendToAll((IMessage)update);
        } else {
            this.network.sendToServer((IMessage)update);
        }
    }

    byte[] getData(HpmsValue value, int chunkX, int chunkZ, int blockX, int blockZ, int blockY) {
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
        short key = this.createKey(blockX, blockZ, blockY);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(chunk);
        if (blockMap != null) {
            return blockMap.get(key);
        }
        return null;
    }

    public Packet.FetchChunkResponse sendChunkToClient(Packet.FetchChunkRequest message) {
        HpmsValue value = this.values.get(message.valueId);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(message.chunk);
        if (blockMap != null) {
            ByteBuffer data = this.convertChunkToBytes(blockMap, value.size);
            Packet.FetchChunkResponse response = new Packet.FetchChunkResponse(message.valueId, message.chunk, data);
            return response;
        }
        return null;
    }

    public void receiveChunkFromServer(Packet.FetchChunkResponse message) {
        HpmsValue value = this.values.get(message.valueId);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = this.convertBytesToChunk(message.data, value.size);
        chunkMap.put(message.chunk, blockMap);
    }

    public void receiveUpdateFromServer(Packet.UpdateBlockMessage message) {
        HpmsValue value = this.values.get(message.valueId);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(message.chunk);
        if (blockMap == null) {
            blockMap = new HashMap<Short, byte[]>();
            chunkMap.put(message.chunk, blockMap);
        }
        blockMap.put(message.key, message.data);
    }

    public void receiveUpdateFromClient(Packet.UpdateBlockMessage message) {
        HpmsValue value = this.values.get(message.valueId);
        Map<ChunkCoordIntPair, Map<Short, byte[]>> chunkMap = this.valueMap.get(value);
        Map<Short, byte[]> blockMap = chunkMap.get(message.chunk);
        if (blockMap == null) {
            blockMap = new HashMap<Short, byte[]>();
            chunkMap.put(message.chunk, blockMap);
        }
        blockMap.put(message.key, message.data);
        if (!this.dirtyChunks.get(value).contains(message.chunk)) {
            this.dirtyChunks.get(value).add(message.chunk);
        }
    }

    private short createKey(int blockX, int blockZ, int blockY) {
        int key = blockX << 12;
        key |= blockZ << 8;
        return (short)(key |= blockY);
    }

    private ByteBuffer convertChunkToBytes(Map<Short, byte[]> blockMap, int valueSize) {
        int bufferSize = (2 + valueSize) * blockMap.size();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (Map.Entry<Short, byte[]> item : blockMap.entrySet()) {
            buffer.putShort(item.getKey());
            buffer.put(item.getValue());
        }
        return buffer;
    }

    private Map<Short, byte[]> convertBytesToChunk(ByteBuffer buffer, int valueSize) {
        int blockCount = buffer.capacity() / (2 + valueSize);
        HashMap<Short, byte[]> blockMap = new HashMap<Short, byte[]>(blockCount);
        for (int i = 0; i < blockCount; ++i) {
            short key = buffer.getShort();
            byte[] value = new byte[valueSize];
            buffer.get(value);
            blockMap.put(key, value);
        }
        return blockMap;
    }

    public static enum CachePreloadMode {
        Everything,
        ActiveChunks,
        Nothing;

    }
}

