/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import uk.co.stealthware.minecraft.ModVersionChecker;

public abstract class StealthwareMod {
    public Configuration config;
    private boolean checkVersion = true;
    private ModVersionChecker mvc;

    protected StealthwareMod() {
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadConfig();
        this.saveConfig();
        if (this.checkVersion) {
            this.mvc = new ModVersionChecker(this);
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.checkVersion) {
            this.mvc.load();
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    public String getName() {
        return this.getClass().getAnnotation(Mod.class).modid();
    }

    public String getFriendlyName() {
        return this.getClass().getAnnotation(Mod.class).name();
    }

    public String getUrl() {
        return FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata().url;
    }

    public String getModVersion() {
        return this.getClass().getAnnotation(Mod.class).version();
    }

    public String getMinecraftVersion() {
        return "1.7.10";
    }

    public String getFullVersion() {
        return this.getModVersion() + " [" + this.getMinecraftVersion() + "]";
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (this.checkVersion) {
            this.mvc.check();
        }
    }

    protected int config_getEntityId(String name, int defaultId) {
        return this.config.get("entity", name, defaultId).getInt();
    }

    protected boolean config_getEnabled(String name, String comment, boolean defaultValue) {
        Property prop = this.config.get("general", "Enable_" + name, defaultValue);
        prop.comment = comment;
        return prop.getBoolean(defaultValue);
    }

    protected boolean config_getFeatureEnabled(String name, String comment, boolean defaultValue) {
        Property prop = this.config.get("features", "Enable_" + name, defaultValue);
        prop.comment = comment;
        return prop.getBoolean(defaultValue);
    }

    protected int config_getRangeValue(String name, String comment, int defaultValue, int min, int max) {
        return this.config_getRangeValue("general", name, comment, defaultValue, min, max);
    }

    protected int config_getRangeValue(String category, String name, String comment, int defaultValue, int min, int max) {
        Property prop = this.config.get(category, name, defaultValue);
        prop.comment = comment + " (valid range: " + min + "-" + max + ")";
        int value = prop.getInt();
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equals(this.getName())) {
            this.loadConfig();
            this.saveConfig();
        }
    }

    protected void saveConfig() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    protected void loadConfig() {
        this.checkVersion = this.config_getEnabled("ModVersionChecker", "true to enable automatic checking for new mod versions", this.checkVersion);
    }

    protected void registerBlock(Block block, String name) {
        block.func_149663_c(name);
        GameRegistry.registerBlock((Block)block, ItemBlock.class, (String)name);
    }

    protected void registerItem(Item item, String name) {
        item.func_77655_b(name);
        GameRegistry.registerItem((Item)item, (String)name, (String)this.getName());
    }
}

