/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.tweakpack.block;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import uk.co.stealthware.tweakpack.TweakPack;

public class BlockClayCauldron
extends BlockCauldron {
    Vector<EntityItem> tossedItems;
    HashMap<ChunkPosition, ClayCauldronIngredients> ingredients;

    public BlockClayCauldron() {
        this.func_149658_d("cauldron");
        this.tossedItems = new Vector();
        this.ingredients = new HashMap();
    }

    public int func_149645_b() {
        return TweakPack.modelClayCauldronId;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        int level = par1World.func_72805_g(par2, par3, par4);
        if (level > 0) {
            ItemStack itemstack1 = new ItemStack(Blocks.field_150435_aG, 1, 0);
            if (!par5EntityPlayer.field_71071_by.func_70441_a(itemstack1)) {
                par1World.func_72838_d((Entity)new EntityItem(par1World, (double)par2 + 0.5, (double)par3 + 1.5, (double)par4 + 0.5, itemstack1));
            } else if (par5EntityPlayer instanceof EntityPlayerMP) {
                ((EntityPlayerMP)par5EntityPlayer).func_71120_a(par5EntityPlayer.field_71069_bz);
            }
            --level;
        }
        if (level > 0) {
            par1World.func_72921_c(par2, par3, par4, level, 3);
        } else {
            par1World.func_147449_b(par2, par3, par4, (Block)Blocks.field_150383_bp);
        }
        return true;
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            Block block = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z);
            int meta = event.entityPlayer.field_70170_p.func_72805_g(event.x, event.y, event.z);
            if (block == Blocks.field_150383_bp && meta == 3) {
                ItemStack held = event.entityPlayer.func_70694_bm();
                if (held != null && held.func_77973_b() == Items.field_151055_y) {
                    ChunkPosition pos = new ChunkPosition(event.x, event.y, event.z);
                    if (this.ingredients.containsKey(pos)) {
                        ClayCauldronIngredients cci = this.ingredients.get(pos);
                        if (cci.dirtRequired == 0 && cci.gravelRequired == 0) {
                            event.entityPlayer.field_70170_p.func_147465_d(event.x, event.y, event.z, (Block)TweakPack.blockClayCauldron, 3, 3);
                            this.ingredients.remove(pos);
                            event.setCanceled(true);
                        }
                    }
                } else if (held != null && (held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) || held.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n)) && this.addIngredient(new ChunkPosition(event.x, event.y, event.z), held)) {
                    --held.field_77994_a;
                    event.setCanceled(true);
                }
            }
        }
    }

    public void onItemTossed(ItemTossEvent event) {
        ItemStack item = event.entityItem.func_92059_d();
        if ((item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n)) && item.field_77994_a == 1) {
            this.tossedItems.add(event.entityItem);
        }
    }

    public void update() {
        Object[] array = new EntityItem[this.tossedItems.size()];
        this.tossedItems.copyInto(array);
        for (Object entity : array) {
            if (((EntityItem)entity).field_70170_p.field_72995_K) {
                return;
            }
            if (((EntityItem)entity).field_70128_L) {
                this.tossedItems.remove(entity);
                continue;
            }
            if (!((EntityItem)entity).field_70132_H) continue;
            int x = (int)((EntityItem)entity).field_70165_t;
            int y = (int)(((EntityItem)entity).field_70163_u - (double)0.2f);
            int z = (int)((EntityItem)entity).field_70161_v;
            if (((EntityItem)entity).field_70170_p.func_147439_a(x, y, z) == Blocks.field_150383_bp && this.addIngredient(new ChunkPosition(x, y, z), entity.func_92059_d())) {
                entity.func_70106_y();
            }
            this.tossedItems.remove(entity);
        }
    }

    private boolean addIngredient(ChunkPosition chunkPosition, ItemStack item) {
        boolean ingredientUsed = false;
        if (!this.ingredients.containsKey(chunkPosition)) {
            this.ingredients.put(chunkPosition, new ClayCauldronIngredients());
        }
        ClayCauldronIngredients cci = this.ingredients.get(chunkPosition);
        if (item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) && cci.dirtRequired > 0) {
            --cci.dirtRequired;
            ingredientUsed = true;
        } else if (item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n) && cci.gravelRequired > 0) {
            --cci.gravelRequired;
            ingredientUsed = true;
        }
        return ingredientUsed;
    }

    class ClayCauldronIngredients {
        int dirtRequired = 2;
        int gravelRequired = 1;
    }
}

