/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.tweakpack;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import uk.co.stealthware.minecraft.StealthwareBlock;
import uk.co.stealthware.minecraft.StealthwareMod;
import uk.co.stealthware.tweakpack.CommonProxy;
import uk.co.stealthware.tweakpack.Packet;
import uk.co.stealthware.tweakpack.PacketHandler;
import uk.co.stealthware.tweakpack.block.BlockClayCauldron;
import uk.co.stealthware.tweakpack.block.BlockGlassSlab;
import uk.co.stealthware.tweakpack.block.BlockMultiCommandBlock;
import uk.co.stealthware.tweakpack.render.RenderPlayerCape;
import uk.co.stealthware.tweakpack.tileentity.TileEntityMultiCommandBlock;

@Mod(modid="FearTweakPack", name="Fearitude's Tweak Pack", version="1.1", useMetadata=true)
public class TweakPack
extends StealthwareMod {
    public static boolean claySoilEnabled = true;
    public static boolean extraClayEnabled = true;
    public static boolean quartzStoneEnabled = true;
    public static boolean woolStringEnabled = true;
    public static boolean enderNoPickupEnabled = true;
    public static boolean stackableSaddlesEnabled = true;
    public static boolean stackableDoorsEnabled = true;
    public static boolean multiCommandBlockEnabled = true;
    public static boolean glassSlabEnabled = true;
    public static boolean storageBlocksEnabled = true;
    public static boolean serverCapesEnabled = false;
    public static boolean doubleBlocksEnabled = true;
    public static int clayDropChance = 15;
    public static int doubleChance = 30;
    public static int quartzStoneDropChance = 10;
    public static int quartzSandDropChance = 20;
    public static int modelClayCauldronId;
    public static int modelDoubleFloorId;
    @SidedProxy(clientSide="uk.co.stealthware.tweakpack.ClientProxy", serverSide="uk.co.stealthware.tweakpack.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static CreativeTabs floorBlocksTab;
    public static CreativeTabs wallBlocksTab;
    public static Block blockMultiCommandBlock;
    public static Block blockGlassSlab;
    public static BlockClayCauldron blockClayCauldron;
    public static Block blockLargeBricks;
    public static Block blockFlintStorage;
    public static Block blockBoneStorage;
    public static Block blockGunpowderStorage;
    @SideOnly(value=Side.CLIENT)
    public static RenderPlayerCape renderPlayerCape;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        claySoilEnabled = this.config_getFeatureEnabled("ClaySoil", "Adds a random clay drop to Dirt based blocks.", claySoilEnabled);
        extraClayEnabled = this.config_getFeatureEnabled("ExtraClay", "Enables extra clay features, includes cauldron crafting and large bricks.", extraClayEnabled);
        quartzStoneEnabled = this.config_getFeatureEnabled("QuartzStone", "Adds a random quartz drop to Stone and SandStone blocks.", quartzStoneEnabled);
        woolStringEnabled = this.config_getFeatureEnabled("WoolString", "Allows crafting wool to make string.", woolStringEnabled);
        enderNoPickupEnabled = this.config_getFeatureEnabled("EnderNoPickup", "Prevents Endermen from picking up blocks.", enderNoPickupEnabled);
        stackableSaddlesEnabled = this.config_getFeatureEnabled("StackSaddles", "Allows saddles to stack for easier storage.", stackableSaddlesEnabled);
        stackableDoorsEnabled = this.config_getFeatureEnabled("StackDoors", "Allows doors to stack for easier storage.", stackableDoorsEnabled);
        multiCommandBlockEnabled = this.config_getFeatureEnabled("MultiCommandBlock", "Enables the Multi-Command Block.", multiCommandBlockEnabled);
        glassSlabEnabled = this.config_getFeatureEnabled("GlassSlab", "Enables Glass Slab blocks.", glassSlabEnabled);
        storageBlocksEnabled = this.config_getFeatureEnabled("StorageBlocks", "Enables additional storage blocks for Flint, Bone and Gunpowder.", storageBlocksEnabled);
        serverCapesEnabled = this.config_getFeatureEnabled("ServerCapes", "Allows multiplayer servers to set capes for players. Note: See EULA!", serverCapesEnabled);
        clayDropChance = this.config_getRangeValue("ClayDropChance", "The percentage chance of dropping Clay", clayDropChance, 0, 100);
        doubleChance = this.config_getRangeValue("DoubleChance", "The percentage chance of dropping 2 pieces instead of 1", doubleChance, 0, 100);
        quartzStoneDropChance = this.config_getRangeValue("QuartzDropChance_Stone", "The percentage chance of dropping Quartz from Stone blocks", quartzStoneDropChance, 0, 100);
        quartzSandDropChance = this.config_getRangeValue("QuartzDropChance_SandStone", "The percentage chance of dropping Quartz from SandStone blocks", quartzSandDropChance, 0, 100);
        this.config.save();
        if (multiCommandBlockEnabled) {
            blockMultiCommandBlock = new BlockMultiCommandBlock();
            this.registerBlock(blockMultiCommandBlock, "commandBlockMulti");
        }
        if (glassSlabEnabled) {
            blockGlassSlab = new BlockGlassSlab(false);
            this.registerBlock(blockGlassSlab, "glassSlab");
        }
        if (extraClayEnabled) {
            blockClayCauldron = new BlockClayCauldron();
            blockLargeBricks = new StealthwareBlock(Material.field_151576_e, (StealthwareMod)this);
            blockLargeBricks.func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(Block.field_149769_e).func_149647_a(CreativeTabs.field_78030_b);
            this.registerBlock((Block)blockClayCauldron, "clayCauldron");
            this.registerBlock(blockLargeBricks, "largeBricks");
        }
        if (storageBlocksEnabled) {
            blockFlintStorage = new StealthwareBlock(Material.field_151576_e, (StealthwareMod)this);
            blockFlintStorage.func_149711_c(1.0f).func_149752_b(10.0f).func_149672_a(Block.field_149769_e).func_149647_a(CreativeTabs.field_78030_b);
            blockBoneStorage = new StealthwareBlock(Material.field_151595_p, (StealthwareMod)this);
            blockBoneStorage.func_149711_c(0.5f).func_149752_b(5.0f).func_149672_a(Block.field_149769_e).func_149647_a(CreativeTabs.field_78030_b);
            blockGunpowderStorage = new StealthwareBlock(Material.field_151595_p, (StealthwareMod)this);
            blockGunpowderStorage.func_149711_c(0.1f).func_149752_b(0.1f).func_149672_a(Block.field_149776_m).func_149647_a(CreativeTabs.field_78030_b);
            this.registerBlock(blockFlintStorage, "flint");
            this.registerBlock(blockBoneStorage, "bone");
            this.registerBlock(blockGunpowderStorage, "gunpowder");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        network = new SimpleNetworkWrapper("FearTweakPack_C1");
        network.registerMessage(PacketHandler.CapeRequestHandler.class, Packet.CapeRequest.class, 1, Side.SERVER);
        network.registerMessage(PacketHandler.CapeResponseHandler.class, Packet.CapeResponse.class, 2, Side.CLIENT);
        if (woolStringEnabled) {
            for (int i = 0; i < 16; ++i) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151007_F, 4), (Object[])new Object[]{new ItemStack(Blocks.field_150325_L, 1, i)});
            }
        }
        if (enderNoPickupEnabled) {
            for (Object item : Block.field_149771_c) {
                Block block = (Block)item;
                if (!EntityEnderman.getCarriable((Block)block)) continue;
                EntityEnderman.setCarriable((Block)block, (boolean)false);
            }
        }
        if (stackableSaddlesEnabled) {
            Items.field_151141_av.func_77625_d(8);
        }
        if (stackableDoorsEnabled) {
            Items.field_151135_aq.func_77625_d(8);
            Items.field_151139_aw.func_77625_d(8);
        }
        if (multiCommandBlockEnabled) {
            GameRegistry.registerTileEntity(TileEntityMultiCommandBlock.class, (String)"MultiCommandBlock");
        }
        if (glassSlabEnabled) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockGlassSlab, 6), (Object[])new Object[]{"###", Character.valueOf('#'), Blocks.field_150359_w});
        }
        if (extraClayEnabled) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockLargeBricks, 1), (Object[])new Object[]{"###", "###", Character.valueOf('#'), Items.field_151118_aC});
        }
        if (storageBlocksEnabled) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockFlintStorage), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151145_ak});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151145_ak, 9), (Object[])new Object[]{blockFlintStorage});
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockBoneStorage), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151103_aS});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151103_aS, 9), (Object[])new Object[]{blockBoneStorage});
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockGunpowderStorage), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151016_H});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151016_H, 9), (Object[])new Object[]{blockGunpowderStorage});
        }
        proxy.setupRenderer();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        if (claySoilEnabled && (event.block instanceof BlockDirt || event.block instanceof BlockGrass || event.block instanceof BlockMycelium || event.block instanceof BlockFarmland)) {
            TweakPack.dropClay(event);
        } else if (quartzStoneEnabled && (event.block instanceof BlockStone || event.block instanceof BlockSandStone)) {
            TweakPack.dropQuartz(event);
        }
    }

    public static void dropClay(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K || !event.world.func_82736_K().func_82766_b("doTileDrops") || event.harvester == null || event.harvester.field_71075_bZ.field_75098_d || event.isSilkTouching) {
            return;
        }
        int fortuneModifier = event.world.field_73012_v.nextInt(event.fortuneLevel + 1);
        if (event.world.field_73012_v.nextFloat() <= (float)clayDropChance / 100.0f) {
            event.drops.add(new ItemStack(Items.field_151119_aD, 1 + fortuneModifier));
            if (event.world.field_73012_v.nextFloat() <= (float)doubleChance / 100.0f) {
                event.drops.add(new ItemStack(Items.field_151119_aD, 1 + fortuneModifier));
            }
        }
    }

    public static void dropQuartz(BlockEvent.HarvestDropsEvent event) {
        if (event.world.field_72995_K || !event.world.func_82736_K().func_82766_b("doTileDrops") || event.harvester == null || event.harvester.field_71075_bZ.field_75098_d || event.isSilkTouching) {
            return;
        }
        int fortuneModifier = event.world.field_73012_v.nextInt(event.fortuneLevel + 1);
        int chance = quartzStoneDropChance;
        if (event.block instanceof BlockSandStone) {
            chance = quartzSandDropChance;
        }
        if (event.world.field_73012_v.nextFloat() <= (float)chance / 100.0f) {
            event.drops.add(new ItemStack(Items.field_151128_bU, 1 + fortuneModifier));
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K || !extraClayEnabled) {
            return;
        }
        blockClayCauldron.onPlayerInteract(event);
    }

    @SubscribeEvent
    public void onItemTossed(ItemTossEvent event) {
        if (event.player.field_70170_p.field_72995_K || !extraClayEnabled) {
            return;
        }
        blockClayCauldron.onItemTossed(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRendered(RenderPlayerEvent.Specials.Post event) {
        if (!serverCapesEnabled) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.entityPlayer;
        if (player.func_82150_aj() || player.func_82238_cc()) {
            return;
        }
        boolean hasNormalCape = player.func_152122_n();
        if (hasNormalCape) {
            return;
        }
        if (renderPlayerCape.hasCape(player.func_70005_c_())) {
            renderPlayerCape.render(player, event.partialRenderTick);
        } else if (!renderPlayerCape.requestedCape(player.func_70005_c_())) {
            renderPlayerCape.requestCape(player.func_70005_c_());
        }
    }

    public static Packet.CapeResponse findServerCape(String name) {
        try {
            String capeDir = "capes/";
            File file = new File(capeDir + name + ".png");
            if (file.exists() && file.canRead()) {
                byte[] temp = new byte[(int)file.length()];
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                input.read(temp);
                input.close();
                Packet.CapeResponse resp = new Packet.CapeResponse();
                resp.name = name;
                resp.image = temp;
                return resp;
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && extraClayEnabled) {
            blockClayCauldron.update();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END && extraClayEnabled) {
            blockClayCauldron.update();
        }
    }
}

