/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.gui.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;
import uk.co.stealthware.scg.command.Command;
import uk.co.stealthware.scg.command.param.NumberParameter;
import uk.co.stealthware.scg.command.param.Parameter;
import uk.co.stealthware.scg.gui.GuiServerCommand;
import uk.co.stealthware.scg.gui.IGuiComponent;

public class EnterNumber
implements IGuiComponent {
    private static final String allowedCharacters = "-0123456789";
    private GuiServerCommand gui;
    private FontRenderer fontRenderer;
    private int lastX;
    private int lastY;
    private Command command;
    private NumberParameter parameter;
    private String inputText;

    public EnterNumber(GuiServerCommand gui, FontRenderer fontRenderer, Command command, Parameter parameter) {
        this.gui = gui;
        this.fontRenderer = fontRenderer;
        this.command = command;
        this.parameter = (NumberParameter)parameter;
        this.inputText = "" + this.parameter.getDefault();
    }

    @Override
    public int getWidth() {
        String prompt = this.parameter.getLabel() + ":";
        int pWidth = this.fontRenderer.func_78256_a(prompt);
        return pWidth + 50;
    }

    @Override
    public int getHeight() {
        return this.fontRenderer.field_78288_b + 1;
    }

    @Override
    public String getTitle() {
        return this.command.getName();
    }

    @Override
    public String getHelp() {
        return this.command.getHelp();
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 200) {
            this.alterNumber(1);
        } else if (i == 208) {
            this.alterNumber(-1);
        } else if (i == 28) {
            this.select();
        } else if (this.inputText != null) {
            if (i == 14 && this.inputText.length() > 0) {
                this.inputText = this.inputText.substring(0, this.inputText.length() - 1);
            }
            if (allowedCharacters.indexOf(c) >= 0 && this.inputText.length() < 10) {
                this.inputText = this.inputText + c;
            }
        }
    }

    @Override
    public void mouseMove(int x, int y) {
    }

    @Override
    public void mouseClick(int x, int y) {
        int totalWidth = this.getWidth();
        if (x >= this.lastX + totalWidth - 5 && x <= this.lastX + totalWidth) {
            if (y >= this.lastY + 1 && y <= this.lastY + 1 + 3) {
                this.alterNumber(1);
            } else if (y >= this.lastY + 5 && y <= this.lastY + 5 + 3) {
                this.alterNumber(-1);
            }
        }
    }

    private void alterNumber(int diff) {
        try {
            int number = Integer.parseInt(this.inputText);
            if ((number += diff) >= this.parameter.getMin() && number <= this.parameter.getMax()) {
                this.inputText = "" + number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void select() {
        boolean inputOk = this.parameter.setInput(this.inputText);
        if (inputOk) {
            this.gui.selectCommand(this.command);
        }
    }

    @Override
    public void renderComponent(int x, int y) {
        this.lastX = x;
        this.lastY = y;
        int colour = 0xE0E0E0;
        String prompt = this.parameter.getLabel() + ":";
        int pWidth = this.fontRenderer.func_78256_a(prompt);
        this.fontRenderer.func_78276_b(prompt, x, y + 1, colour);
        this.fontRenderer.func_78276_b(this.inputText, x + pWidth + 5, y + 1, colour);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.gui.field_110324_m);
        int totalWidth = this.getWidth();
        this.gui.func_73729_b(x + totalWidth - 5, y + 1, 0, 14, 5, 3);
        this.gui.func_73729_b(x + totalWidth - 5, y + 5, 0, 16, 5, 3);
        if (this.gui.updateCounter / 6 % 2 == 0) {
            int width = this.fontRenderer.func_78256_a(this.inputText);
            this.gui.func_73729_b(x + pWidth + 5 + width, y + 1, 0, 6, 3, 8);
        }
    }

    @Override
    public void reset() {
        this.command.clearInput();
    }
}

