/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.gui.input;

import java.util.Vector;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import uk.co.stealthware.scg.command.Command;
import uk.co.stealthware.scg.command.param.Parameter;
import uk.co.stealthware.scg.command.param.SelectParameter;
import uk.co.stealthware.scg.gui.GuiServerCommand;
import uk.co.stealthware.scg.gui.IGuiComponent;

public class ChooseList
implements IGuiComponent {
    protected GuiServerCommand gui;
    protected FontRenderer fontRenderer;
    private int lastX;
    private int lastY;
    protected Command command;
    protected Parameter parameter;
    protected Vector<String> names;
    protected Vector<String> values;
    protected int highlighted;

    public ChooseList(GuiServerCommand gui, FontRenderer fontRenderer, Command command, Parameter parameter) {
        this.gui = gui;
        this.fontRenderer = fontRenderer;
        this.command = command;
        this.parameter = parameter;
        if (parameter instanceof SelectParameter) {
            this.names = ((SelectParameter)parameter).selectNames;
            this.values = ((SelectParameter)parameter).selectValues;
        }
        this.highlighted = 0;
    }

    @Override
    public int getWidth() {
        int menuWidth = 80;
        for (int idx = 0; idx < this.names.size(); ++idx) {
            int width = this.fontRenderer.func_78256_a(this.names.get(idx));
            menuWidth = Math.max(menuWidth, width);
        }
        return menuWidth;
    }

    @Override
    public int getHeight() {
        int menuHeight = (this.fontRenderer.field_78288_b + 1) * this.names.size();
        return menuHeight;
    }

    @Override
    public String getTitle() {
        return this.command.getName() + " - " + this.parameter.getLabel();
    }

    @Override
    public String getHelp() {
        return this.command.getHelp();
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 200) {
            this.up();
        } else if (i == 208) {
            this.down();
        } else if (i == 28) {
            this.select();
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        int idx = this.getMouseIndex(x, y);
        if (idx != -1) {
            this.highlighted = idx;
        }
    }

    private int getMouseIndex(int x, int y) {
        if (x >= this.lastX && x <= this.lastX + this.getWidth()) {
            for (int idx = 0; idx < this.names.size(); ++idx) {
                if (y < this.lastY + (this.fontRenderer.field_78288_b + 1) * idx || y > this.lastY + (this.fontRenderer.field_78288_b + 1) * (idx + 1)) continue;
                return idx;
            }
        }
        return -1;
    }

    @Override
    public void mouseClick(int x, int y) {
        int idx = this.getMouseIndex(x, y);
        if (idx != -1) {
            this.highlighted = idx;
            this.select();
            this.gui.playClickSound();
        }
    }

    public void up() {
        --this.highlighted;
        if (this.highlighted < 0) {
            this.highlighted = this.names.size() - 1;
        }
    }

    public void down() {
        ++this.highlighted;
        if (this.highlighted >= this.names.size()) {
            this.highlighted = 0;
        }
    }

    public void select() {
        boolean inputOk = this.parameter.setInput(this.values.get(this.highlighted));
        if (!inputOk) {
            return;
        }
        this.gui.selectCommand(this.command);
    }

    @Override
    public void renderComponent(int x, int y) {
        this.lastX = x;
        this.lastY = y;
        for (int idx = 0; idx < this.names.size(); ++idx) {
            int colour = 0xE0E0E0;
            if (this.highlighted == idx) {
                colour = 0;
                int highlightColour = this.gui.fadeColourAlpha(-2130706433, -1593835521);
                Gui.func_73734_a((int)(x - 2), (int)(y + (this.fontRenderer.field_78288_b + 1) * idx), (int)(x + this.getWidth() + 2), (int)(y + (this.fontRenderer.field_78288_b + 1) * (idx + 1)), (int)highlightColour);
            }
            this.fontRenderer.func_78276_b(this.names.get(idx), x, y + 10 * idx + 1, colour);
        }
    }

    @Override
    public void reset() {
        this.command.clearInput();
    }
}

