/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.gui.input;

import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import uk.co.stealthware.scg.command.Command;
import uk.co.stealthware.scg.command.param.Parameter;
import uk.co.stealthware.scg.gui.GuiServerCommand;
import uk.co.stealthware.scg.gui.IGuiComponent;

public class ChooseItem
implements IGuiComponent {
    protected static RenderItem itemRenderer = new RenderItem();
    private GuiServerCommand gui;
    private FontRenderer fontRenderer;
    private int lastX;
    private int lastY;
    private Command command;
    private Parameter parameter;
    private String inputText;
    Vector<CreativeTabs> tabs;
    List itemsList;
    int tab;
    int highlight;
    int tabHighlight = -1;

    public ChooseItem(GuiServerCommand gui, FontRenderer fontRenderer, Command command, Parameter parameter) {
        this.gui = gui;
        this.fontRenderer = fontRenderer;
        this.command = command;
        this.parameter = parameter;
        this.inputText = "";
        this.tabs = new Vector();
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (tab == CreativeTabs.field_78027_g || tab == CreativeTabs.field_78036_m) continue;
            this.tabs.add(tab);
        }
        this.itemsList = new ArrayList();
        this.tab = 0;
        this.changeTab();
    }

    private void changeTab() {
        CreativeTabs current = this.tabs.get(this.tab);
        this.itemsList.clear();
        for (Object obj : Item.field_150901_e) {
            Item item = (Item)obj;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab != current) continue;
                item.func_150895_a(item, tab, this.itemsList);
            }
        }
        this.highlight = -1;
        this.tabHighlight = -1;
    }

    @Override
    public int getWidth() {
        return 144;
    }

    @Override
    public int getHeight() {
        int heightMain = this.itemsList.size() / 9 * 16 + 16 + 5 + (this.fontRenderer.field_78288_b + 1);
        int heightTabs = this.tabs.size() * 17;
        return Math.max(heightMain, heightTabs);
    }

    @Override
    public String getTitle() {
        return this.command.getName();
    }

    @Override
    public String getHelp() {
        return this.command.getHelp();
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 28) {
            this.select();
        }
        if (i == 200) {
            this.changeHighlight(-9);
        } else if (i == 208) {
            this.changeHighlight(9);
        } else if (i == 205) {
            this.changeHighlight(1);
        } else if (i == 203) {
            this.changeHighlight(-1);
        } else if (i == 201) {
            --this.tab;
            if (this.tab < 0) {
                this.tab = this.tabs.size() - 1;
            }
            this.changeTab();
        } else if (i == 209) {
            ++this.tab;
            if (this.tab >= this.tabs.size()) {
                this.tab = 0;
            }
            this.changeTab();
        } else if (this.inputText != null) {
            if (i == 14 && this.inputText.length() > 0) {
                this.inputText = this.inputText.substring(0, this.inputText.length() - 1);
            }
            if (this.inputText.length() < 50) {
                this.inputText = this.inputText + c;
            }
        }
    }

    private void changeHighlight(int increment) {
        this.highlight += increment;
        this.setHighlight();
    }

    private void setHighlight() {
        if (this.highlight < 0) {
            this.highlight = 0;
        } else if (this.highlight >= this.itemsList.size()) {
            this.highlight = this.itemsList.size() - 1;
        }
        ItemStack itemstack = (ItemStack)this.itemsList.get(this.highlight);
        String name = GameData.getItemRegistry().func_148750_c((Object)itemstack.func_77973_b());
        this.inputText = name.startsWith("minecraft:") ? name.substring(10) : name;
        if (itemstack.func_77981_g()) {
            this.inputText = this.inputText + "/" + itemstack.func_77960_j();
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        int i;
        this.tabHighlight = -1;
        int totalWidth = this.getWidth();
        int left = this.lastX + totalWidth + 4;
        if (x >= left && x <= left + 18) {
            for (i = 0; i < this.tabs.size(); ++i) {
                int top = this.lastY + i * 17;
                if (y < top || y > top + 18) continue;
                this.tabHighlight = i;
                break;
            }
        }
        for (i = 0; i < this.itemsList.size(); ++i) {
            int posX = i % 9 * 16;
            int posY = i / 9 * 16;
            if (x < this.lastX + posX || x > this.lastX + posX + 16 || y < this.lastY + posY || y > this.lastY + posY + 16) continue;
            this.highlight = i;
            this.setHighlight();
            break;
        }
    }

    @Override
    public void mouseClick(int x, int y) {
        int i;
        int totalWidth = this.getWidth();
        int left = this.lastX + totalWidth + 4;
        if (x >= left && x <= left + 18) {
            for (i = 0; i < this.tabs.size(); ++i) {
                int top = this.lastY + i * 17;
                if (y < top || y > top + 18) continue;
                this.tab = i;
                this.changeTab();
                break;
            }
        }
        for (i = 0; i < this.itemsList.size(); ++i) {
            int posX = i % 9 * 16;
            int posY = i / 9 * 16;
            if (x < this.lastX + posX || x > this.lastX + posX + 16 || y < this.lastY + posY || y > this.lastY + posY + 16) continue;
            this.highlight = i;
            this.setHighlight();
            this.select();
            break;
        }
    }

    public void select() {
        boolean inputOk = this.parameter.setInput(this.inputText);
        if (inputOk) {
            this.gui.selectCommand(this.command);
        }
    }

    @Override
    public void renderComponent(int x, int y) {
        int i;
        this.lastX = x;
        this.lastY = y;
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int totalWidth = this.getWidth();
        for (i = 0; i < this.tabs.size(); ++i) {
            int left = x + totalWidth + 4;
            int top = y + i * 17;
            int tcolour = Integer.MIN_VALUE;
            if (this.tab == i) {
                tcolour = -2131824914;
            } else if (this.tabHighlight == i) {
                tcolour = -2130706433;
            }
            Gui.func_73734_a((int)left, (int)top, (int)(left + 18), (int)(top + 18), (int)tcolour);
            this.gui.drawBorder(left, top, left + 18, top + 18);
            ItemStack itemstack = this.tabs.get(i).func_151244_d();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            ChooseItem.itemRenderer.field_77023_b += 100.0f;
            itemRenderer.func_82406_b(this.fontRenderer, textureManager, itemstack, left + 1, top + 1);
            itemRenderer.func_77021_b(this.fontRenderer, textureManager, itemstack, left + 1, top + 1);
            ChooseItem.itemRenderer.field_77023_b -= 100.0f;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (Tessellator.renderingWorldRenderer) {
                Tessellator.field_78398_a.func_78381_a();
            }
            if (this.tabHighlight != i) continue;
            String label = I18n.func_135052_a((String)this.tabs.get(i).func_78024_c(), (Object[])new Object[0]);
            Gui.func_73734_a((int)(left + 20), (int)top, (int)(left + 20 + this.fontRenderer.func_78256_a(label) + 4), (int)(top + 10), (int)Integer.MIN_VALUE);
            this.fontRenderer.func_78276_b(label, left + 20 + 2, top + 1, 0xE0E0E0);
        }
        for (i = 0; i < this.itemsList.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.itemsList.get(i);
            int posX = i % 9 * 16;
            int posY = i / 9 * 16;
            if (this.highlight == i) {
                int highlightColour = this.gui.fadeColourAlpha(-2130706433, -1593835521);
                Gui.func_73734_a((int)(x + posX), (int)(y + posY), (int)(x + posX + 16), (int)(y + posY + 16), (int)highlightColour);
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            ChooseItem.itemRenderer.field_77023_b += 100.0f;
            itemRenderer.func_82406_b(this.fontRenderer, textureManager, itemstack, x + posX, y + posY);
            itemRenderer.func_77021_b(this.fontRenderer, textureManager, itemstack, x + posX, y + posY);
            ChooseItem.itemRenderer.field_77023_b -= 100.0f;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            if (!Tessellator.renderingWorldRenderer) continue;
            Tessellator.field_78398_a.func_78381_a();
        }
        int itemsHeight = this.getHeight() - (this.fontRenderer.field_78288_b + 1);
        int colour = 0xE0E0E0;
        String prompt = this.parameter.getLabel() + ":";
        int pWidth = this.fontRenderer.func_78256_a(prompt);
        this.fontRenderer.func_78276_b(prompt, x, y + itemsHeight + 1, colour);
        this.fontRenderer.func_78276_b(this.inputText, x + pWidth + 5, y + itemsHeight + 1, colour);
        if (this.gui.updateCounter / 6 % 2 == 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.gui.field_110324_m);
            int width = this.fontRenderer.func_78256_a(this.inputText);
            this.gui.func_73729_b(x + pWidth + 5 + width, y + itemsHeight + 1, 0, 6, 3, 8);
        }
        if (this.highlight >= 0 && this.tabHighlight == -1) {
            ItemStack itemstack = (ItemStack)this.itemsList.get(this.highlight);
            int posX = x + this.highlight % 9 * 16;
            int posY = y + this.highlight / 9 * 16;
            String label = itemstack.func_82833_r();
            Gui.func_73734_a((int)(posX + 20), (int)posY, (int)(posX + 20 + this.fontRenderer.func_78256_a(label) + 4), (int)(posY + 10), (int)Integer.MIN_VALUE);
            this.fontRenderer.func_78276_b(label, posX + 20 + 2, posY + 1, 0xE0E0E0);
        }
        RenderHelper.func_74519_b();
    }

    @Override
    public void reset() {
        this.command.clearInput();
    }
}

