/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import uk.co.stealthware.scg.ServerCommands;
import uk.co.stealthware.scg.command.Command;
import uk.co.stealthware.scg.command.param.ItemMetaParameter;
import uk.co.stealthware.scg.command.param.ItemParameter;
import uk.co.stealthware.scg.command.param.Parameter;
import uk.co.stealthware.scg.gui.GuiMenu;
import uk.co.stealthware.scg.gui.IGuiComponent;
import uk.co.stealthware.scg.gui.input.ChooseItem;
import uk.co.stealthware.scg.gui.input.ChooseList;
import uk.co.stealthware.scg.gui.input.ChoosePlayer;
import uk.co.stealthware.scg.gui.input.EnterIPAddress;
import uk.co.stealthware.scg.gui.input.EnterNumber;
import uk.co.stealthware.scg.gui.input.EnterText;

public class GuiServerCommand
extends GuiScreen {
    private static final int leftOffset = 5;
    private static final int bottomOffset = 25;
    private static final int xPadding = 5;
    private static final int yPadding = 5;
    public int updateCounter;
    private int lastMouseButton = -1;
    private ServerCommands mod;
    private GuiMenu menu;
    private IGuiComponent currentComponent;
    public ResourceLocation field_110324_m;
    private int showHelp;

    public GuiServerCommand(ServerCommands mod) {
        this.mod = mod;
        this.field_110324_m = new ResourceLocation(mod.getName().toLowerCase() + ":textures/gui/icons.png");
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.menu = new GuiMenu(this, this.field_146289_q, this.mod.commandList);
        this.currentComponent = this.menu;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        ++this.updateCounter;
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            this.close();
        } else {
            if (!this.mod.IsReady() || this.mod.commandList == null) {
                return;
            }
            this.currentComponent.keyTyped(c, i);
        }
    }

    public void func_146274_d() {
        if (!this.mod.IsReady() || this.mod.commandList == null) {
            return;
        }
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        if (Minecraft.field_142025_a && k == 0 && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157))) {
            k = 1;
        }
        if (k == -1) {
            int ccWidth = this.currentComponent.getWidth();
            int ccHeight = this.currentComponent.getHeight();
            int titleWidth = this.field_146289_q.func_78256_a(this.currentComponent.getTitle());
            int helpLeft = Math.max(5 + ccWidth + 10 - 10, 5 + titleWidth + 10);
            if (x >= helpLeft && x <= helpLeft + 10 && y >= this.field_146295_m - (ccHeight + 10 + 25 + 14) && y <= this.field_146295_m - (ccHeight + 10 + 25)) {
                this.help();
            } else {
                this.currentComponent.mouseMove(x, y);
            }
        } else if (Mouse.getEventButtonState()) {
            this.lastMouseButton = k;
        } else if (this.lastMouseButton == k && !Mouse.getEventButtonState()) {
            this.lastMouseButton = -1;
            if (k == 0) {
                if (x >= 0 && x <= 20 && y >= this.field_146295_m - 20 && y <= this.field_146295_m) {
                    this.close();
                } else {
                    this.currentComponent.mouseClick(x, y);
                }
            }
        }
    }

    public void close() {
        this.currentComponent.reset();
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    public void help() {
        this.showHelp = 250;
    }

    public void selectCommand(Command command) {
        if (command.NeedsInput()) {
            Parameter param = command.getNextInputParameter();
            switch (param.getType()) {
                case Player: {
                    this.currentComponent = new ChoosePlayer(this, this.field_146289_q, command, param);
                    break;
                }
                case Select: {
                    this.currentComponent = new ChooseList(this, this.field_146289_q, command, param);
                    break;
                }
                case IPAddress: {
                    this.currentComponent = new EnterIPAddress(this, this.field_146289_q, command, param);
                    break;
                }
                case Item: {
                    this.currentComponent = new ChooseItem(this, this.field_146289_q, command, param);
                    break;
                }
                case ItemMeta: {
                    for (Parameter item : command.parameters) {
                        if (item.getType() != Parameter.ParameterType.Item) continue;
                        ((ItemMetaParameter)param).setFromItemParameter((ItemParameter)item);
                        break;
                    }
                    this.selectCommand(command);
                    break;
                }
                case Number: {
                    this.currentComponent = new EnterNumber(this, this.field_146289_q, command, param);
                    break;
                }
                case Text: {
                    this.currentComponent = new EnterText(this, this.field_146289_q, command, param);
                    break;
                }
            }
        } else {
            String commandStr = command.getCommand();
            this.sendCommand(commandStr);
            command.clearInput();
            this.currentComponent = this.menu;
            this.menu.reset();
        }
    }

    private void sendCommand(String command) {
        this.field_146297_k.field_71439_g.func_71165_d(ServerCommands.commandPrefix + command);
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    public void func_73863_a(int i, int j, float f) {
        if (this.mod.IsReady() && this.mod.commandList != null) {
            int ccWidth = this.currentComponent.getWidth();
            int ccHeight = this.currentComponent.getHeight();
            this.drawBackground(ccWidth, ccHeight);
            int titleWidth = this.drawTitle(ccWidth, ccHeight, this.currentComponent.getTitle());
            this.currentComponent.renderComponent(10, this.field_146295_m - (ccHeight + 5 + 25));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.field_110324_m);
            this.func_73729_b(0, this.field_146295_m - 19, 0, 20, 18, 19);
            String help = this.currentComponent.getHelp();
            int helpLeft = Math.max(5 + ccWidth + 10 - 10, 5 + titleWidth + 10);
            if (help != null && help.length() > 0) {
                this.func_73729_b(helpLeft, this.field_146295_m - (ccHeight + 10 + 25 + 13), 18, 20, 10, 14);
            }
            if (this.showHelp > 0) {
                --this.showHelp;
                this.drawHelp(helpLeft, ccHeight, this.currentComponent.getHelp());
            }
        } else {
            if (this.updateCounter > 40) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
                return;
            }
            this.drawTitle(0, 0, I18n.func_135052_a((String)"gui.notavailable", (Object[])new Object[0]));
        }
        super.func_73863_a(i, j, f);
    }

    private void drawBackground(int contentWidth, int contentHeight) {
        int left = 5;
        int top = this.field_146295_m - (contentHeight + 10 + 25);
        int right = 5 + contentWidth + 10;
        int bottom = this.field_146295_m - 25;
        GuiServerCommand.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Integer.MIN_VALUE);
        this.drawBorder(left, top, right, bottom);
    }

    private int drawTitle(int contentWidth, int contentHeight, String title) {
        int titleHeight = this.field_146289_q.field_78288_b + 4;
        int titleWidth = this.field_146289_q.func_78256_a(title);
        int top = this.field_146295_m - (contentHeight + 10 + 25 + titleHeight);
        int right = 5 + titleWidth + 10;
        int bottom = this.field_146295_m - (contentHeight + 10 + 25) + 1;
        GuiServerCommand.func_73734_a((int)5, (int)top, (int)right, (int)bottom, (int)Integer.MIN_VALUE);
        this.drawBorder(5, top, right, bottom);
        this.field_146289_q.func_78276_b(title, 10, top + 3, 0xE0E0E0);
        return titleWidth;
    }

    private void drawHelp(int titleWidth, int contentHeight, String help) {
        if (help == null || help.length() == 0) {
            this.showHelp = 0;
            return;
        }
        int helpHeight = this.field_146289_q.field_78288_b + 4;
        int helpWidth = this.field_146289_q.func_78256_a(help);
        int left = titleWidth + 12;
        int right = left + helpWidth + 10;
        int top = this.field_146295_m - (contentHeight + 10 + 25 + helpHeight);
        int bottom = this.field_146295_m - (contentHeight + 10 + 25);
        GuiServerCommand.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Integer.MIN_VALUE);
        this.drawBorder(left, top, right, bottom);
        this.field_146289_q.func_78276_b(help, left + 5, top + 3, 0xE0E0E0);
    }

    public void drawBorder(int left, int top, int right, int bottom) {
        int colour = 0x60FFFFFF;
        GuiServerCommand.func_73734_a((int)left, (int)top, (int)right, (int)(top + 1), (int)colour);
        GuiServerCommand.func_73734_a((int)left, (int)(bottom - 1), (int)right, (int)bottom, (int)colour);
        GuiServerCommand.func_73734_a((int)left, (int)top, (int)(left + 1), (int)bottom, (int)colour);
        GuiServerCommand.func_73734_a((int)(right - 1), (int)top, (int)right, (int)bottom, (int)colour);
    }

    public int fadeColourAlpha(int from, int to) {
        int modulo = this.updateCounter % 12;
        if ((modulo = Math.abs(modulo - 6)) < 2) {
            return from;
        }
        int diff = to - from;
        return from + (int)((float)diff * ((float)(modulo -= 2) / 4.0f));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void setCurrentComponent(IGuiComponent currentComponent) {
        this.currentComponent = currentComponent;
    }

    public void playClickSound() {
        this.field_146297_k.field_71441_e.func_72980_b(0.0, 0.0, 0.0, "random.click", 1.0f, 1.0f, false);
    }
}

