/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import uk.co.stealthware.scg.command.Command;
import uk.co.stealthware.scg.command.CommandListItem;
import uk.co.stealthware.scg.gui.GuiServerCommand;
import uk.co.stealthware.scg.gui.IGuiComponent;

public class GuiMenu
implements IGuiComponent {
    private GuiServerCommand gui;
    private FontRenderer fontRenderer;
    private int lastX;
    private int lastY;
    private CommandListItem commandList;
    private CommandListItem selected;
    private int highlighted;

    public GuiMenu(GuiServerCommand gui, FontRenderer fontRenderer, CommandListItem commandList) {
        this.gui = gui;
        this.fontRenderer = fontRenderer;
        this.commandList = commandList;
        this.selected = commandList;
        this.highlighted = 0;
    }

    @Override
    public int getWidth() {
        int menuWidth = 80;
        for (int idx = 0; idx < this.selected.countSubCommands(); ++idx) {
            int width = this.fontRenderer.func_78256_a(this.selected.getSubCommand(idx).getName());
            if (this.selected.getSubCommand(idx).hasSubCommands()) {
                width += 10;
            }
            menuWidth = Math.max(menuWidth, width);
        }
        return menuWidth;
    }

    @Override
    public int getHeight() {
        return (this.fontRenderer.field_78288_b + 1) * this.selected.countSubCommands();
    }

    @Override
    public String getTitle() {
        String title = this.selected.getName();
        if (title == null) {
            title = I18n.func_135052_a((String)"gui.title", (Object[])new Object[0]);
        }
        return title;
    }

    @Override
    public String getHelp() {
        String help = null;
        CommandListItem sub = this.selected.getSubCommand(this.highlighted);
        if (sub != null) {
            help = sub.getHelp();
        }
        if (help == null || help.length() == 0) {
            help = this.selected.getHelp();
        }
        return help;
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i == 200) {
            this.up();
        } else if (i == 208) {
            this.down();
        } else if (i == 205) {
            this.forward();
        } else if (i == 203) {
            this.back();
        } else if (i == 28) {
            boolean canGoForward = this.forward();
            if (!canGoForward) {
                this.select();
            }
        } else if (i == 46) {
            this.gui.close();
        } else if (i == 35) {
            this.gui.help();
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        int idx = this.getMouseIndex(x, y);
        if (idx != -1) {
            this.highlighted = idx;
        }
    }

    private int getMouseIndex(int x, int y) {
        if (x >= this.lastX && x <= this.lastX + this.getWidth()) {
            for (int idx = 0; idx < this.selected.countSubCommands(); ++idx) {
                if (y < this.lastY + (this.fontRenderer.field_78288_b + 1) * idx || y > this.lastY + (this.fontRenderer.field_78288_b + 1) * (idx + 1)) continue;
                return idx;
            }
        }
        return -1;
    }

    @Override
    public void mouseClick(int x, int y) {
        int idx = this.getMouseIndex(x, y);
        if (idx != -1) {
            this.highlighted = idx;
            boolean canGoForward = this.forward();
            if (!canGoForward) {
                this.select();
            }
            this.gui.playClickSound();
        }
    }

    public void up() {
        --this.highlighted;
        if (this.highlighted < 0) {
            this.highlighted = this.selected.countSubCommands() - 1;
        }
    }

    public void down() {
        ++this.highlighted;
        if (this.highlighted >= this.selected.countSubCommands()) {
            this.highlighted = 0;
        }
    }

    public boolean forward() {
        if (this.selected.getSubCommand(this.highlighted).hasSubCommands()) {
            this.selected = this.selected.getSubCommand(this.highlighted);
            this.highlighted = 0;
            return true;
        }
        return false;
    }

    public void back() {
        this.selected = this.commandList;
        this.highlighted = 0;
    }

    public void select() {
        if (this.selected.getSubCommand(this.highlighted).getClass() == Command.class) {
            this.gui.selectCommand((Command)this.selected.getSubCommand(this.highlighted));
        }
    }

    @Override
    public void reset() {
        this.selected = this.commandList;
        this.highlighted = 0;
    }

    @Override
    public void renderComponent(int x, int y) {
        int idx;
        this.lastX = x;
        this.lastY = y;
        int width = this.getWidth();
        for (idx = 0; idx < this.selected.countSubCommands(); ++idx) {
            int colour = 0xE0E0E0;
            if (this.highlighted == idx) {
                colour = 0;
                int highlightColour = this.gui.fadeColourAlpha(-2130706433, -1593835521);
                Gui.func_73734_a((int)(x - 2), (int)(y + (this.fontRenderer.field_78288_b + 1) * idx), (int)(x + width + 2), (int)(y + (this.fontRenderer.field_78288_b + 1) * (idx + 1)), (int)highlightColour);
            }
            this.fontRenderer.func_78276_b(this.selected.getSubCommand(idx).getName(), x, y + (this.fontRenderer.field_78288_b + 1) * idx + 1, colour);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.gui.field_110324_m);
        for (idx = 0; idx < this.selected.countSubCommands(); ++idx) {
            if (!this.selected.getSubCommand(idx).hasSubCommands()) continue;
            this.gui.func_73729_b(x + width - 9, y + (this.fontRenderer.field_78288_b + 1) * idx + 2, 6, 0, 9, 6);
        }
    }
}

