/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.command.param;

import net.minecraft.client.resources.I18n;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Parameter {
    protected ParameterType type;
    protected String fixedCommandText;
    protected String inputValue;
    protected String label;

    public Parameter(ParameterType type) {
        this.type = type;
    }

    public Parameter(String fixedCommandText) {
        this(ParameterType.FixedText);
        this.fixedCommandText = fixedCommandText;
    }

    public Parameter(Node node) {
        if (node.getNodeName() == "text") {
            this.type = ParameterType.Text;
        } else if (node.getNodeName() == "player") {
            this.type = ParameterType.Player;
        }
        NamedNodeMap attrib = node.getAttributes();
        Node label = attrib.getNamedItem("label");
        if (label != null) {
            this.label = label.getNodeValue();
        }
    }

    public boolean NeedsInput() {
        return this.type != ParameterType.FixedText && this.inputValue == null;
    }

    public String toString() {
        switch (this.type) {
            case Text: {
                return this.inputValue;
            }
            case Player: {
                return this.inputValue;
            }
            case IPAddress: {
                return this.inputValue;
            }
            case Select: {
                return this.inputValue;
            }
            case FixedText: {
                return this.fixedCommandText;
            }
        }
        return "";
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public String getLabel() {
        if (this.label == null) {
            switch (this.type) {
                case Text: {
                    return I18n.func_135052_a((String)"gui.label.text", (Object[])new Object[0]);
                }
                case Number: {
                    return I18n.func_135052_a((String)"gui.label.number", (Object[])new Object[0]);
                }
                case Player: {
                    return I18n.func_135052_a((String)"gui.label.player", (Object[])new Object[0]);
                }
                case IPAddress: {
                    return I18n.func_135052_a((String)"gui.label.ip", (Object[])new Object[0]);
                }
                case Select: {
                    return I18n.func_135052_a((String)"gui.label.select", (Object[])new Object[0]);
                }
                case Item: {
                    return I18n.func_135052_a((String)"gui.label.item", (Object[])new Object[0]);
                }
            }
            return "";
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean setInput(String inputText) {
        this.inputValue = inputText;
        return true;
    }

    public void clear() {
        this.inputValue = null;
    }

    public static enum ParameterType {
        Text,
        Number,
        Player,
        IPAddress,
        Select,
        Item,
        FixedText,
        ItemMeta;

    }
}

