/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.command;

import java.util.List;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.stealthware.scg.command.Command;

public class CommandListItem {
    private boolean enabled;
    private String name;
    private String help;
    protected List<CommandListItem> subCommands;

    public CommandListItem(String name) {
        this.name = name;
    }

    public CommandListItem(Node node) {
        this.loadSharedAttributes(node);
    }

    public CommandListItem(NodeList nodeList) {
        this.loadCommandList(nodeList);
    }

    public CommandListItem(Node node, NodeList nodeList) {
        this.loadSharedAttributes(node);
        this.loadCommandList(nodeList);
    }

    protected void loadSharedAttributes(Node node) {
        Node nameAttribute = node.getAttributes().getNamedItem("name");
        Node helpAttribute = node.getAttributes().getNamedItem("help");
        this.setName(nameAttribute.getNodeValue());
        if (helpAttribute != null) {
            this.setHelp(helpAttribute.getNodeValue());
        }
    }

    protected void loadCommandList(NodeList nodeLst) {
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            Node node = nodeLst.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName() == "category") {
                CommandListItem category = new CommandListItem(node, node.getChildNodes());
                this.addSubCommand(category);
                continue;
            }
            if (node.getNodeName() != "command") continue;
            Command command = new Command(node);
            this.addSubCommand(command);
        }
    }

    public boolean isEnabled() {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                if (!sub.isEnabled()) continue;
                return true;
            }
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                sub.setEnabled(enabled);
            }
        } else {
            this.enabled = enabled;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void addSubCommand(CommandListItem command) {
        if (this.subCommands == null) {
            this.subCommands = new Vector<CommandListItem>();
        }
        this.subCommands.add(command);
    }

    public boolean hasSubCommands() {
        return this.subCommands != null && this.countSubCommands() > 0;
    }

    public CommandListItem getSubCommand(int index) {
        int count = 0;
        for (CommandListItem sub : this.subCommands) {
            if (!sub.isEnabled()) continue;
            if (count == index) {
                return sub;
            }
            ++count;
        }
        return null;
    }

    public int countSubCommands() {
        int count = 0;
        for (CommandListItem sub : this.subCommands) {
            if (!sub.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public void enableMatchingCommands(String name) {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                sub.enableMatchingCommands(name);
            }
        }
    }

    public void listCommands(Vector<String> list) {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                sub.listCommands(list);
            }
        }
    }
}

