/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg.command;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.stealthware.scg.command.CommandListItem;
import uk.co.stealthware.scg.command.param.IPAddressParameter;
import uk.co.stealthware.scg.command.param.ItemMetaParameter;
import uk.co.stealthware.scg.command.param.ItemParameter;
import uk.co.stealthware.scg.command.param.NumberParameter;
import uk.co.stealthware.scg.command.param.Parameter;
import uk.co.stealthware.scg.command.param.SelectParameter;

public class Command
extends CommandListItem {
    String command;
    public Vector<Parameter> parameters;

    public Command(Node node) {
        super(node);
        Node commandAttribute = node.getAttributes().getNamedItem("command");
        if (commandAttribute != null) {
            this.command = commandAttribute.getNodeValue();
        }
        if (node.hasChildNodes()) {
            Node fstCldNode = node.getFirstChild();
            if (fstCldNode.getNodeType() == 3 && fstCldNode.getTextContent().trim().length() == 0) {
                fstCldNode = fstCldNode.getNextSibling();
            }
            if (fstCldNode.getNodeType() == 1 && (fstCldNode.getNodeName() == "category" || fstCldNode.getNodeName() == "command")) {
                this.loadCommandList(node.getChildNodes());
            } else {
                this.loadCommandParameters(node.getChildNodes());
            }
        }
    }

    private void loadCommandParameters(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 1 && node.getNodeName() == "param") {
                String str = node.getTextContent().trim();
                if (str.length() <= 0) continue;
                this.addParameter(new Parameter(str));
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName() == "number") {
                this.addParameter(new NumberParameter(node));
                continue;
            }
            if (node.getNodeName() == "item") {
                this.addParameter(new ItemParameter(node));
                continue;
            }
            if (node.getNodeName() == "itemmeta") {
                this.addParameter(new ItemMetaParameter());
                continue;
            }
            if (node.getNodeName() == "select") {
                this.addParameter(new SelectParameter(node));
                continue;
            }
            if (node.getNodeName() == "ip") {
                this.addParameter(new IPAddressParameter(node));
                continue;
            }
            this.addParameter(new Parameter(node));
        }
    }

    public String getCommand() {
        StringBuilder sb = new StringBuilder();
        if (this.command != null) {
            sb.append(this.command);
            sb.append(" ");
        }
        if (this.parameters != null) {
            for (Parameter item : this.parameters) {
                String value = item.toString();
                if (value == null) continue;
                sb.append(value);
                sb.append(" ");
            }
        }
        return sb.toString().trim();
    }

    public boolean NeedsInput() {
        return this.getNextInputParameter() != null;
    }

    public void addParameter(Parameter commandPart) {
        if (this.parameters == null) {
            this.parameters = new Vector();
        }
        this.parameters.add(commandPart);
    }

    public Parameter getNextInputParameter() {
        if (this.parameters != null) {
            for (Parameter item : this.parameters) {
                if (!item.NeedsInput()) continue;
                return item;
            }
        }
        return null;
    }

    public void clearInput() {
        if (this.parameters != null) {
            for (Parameter item : this.parameters) {
                item.clear();
            }
        }
    }

    @Override
    public void enableMatchingCommands(String name) {
        super.enableMatchingCommands(name);
        if (this.command != null && this.command.equals(name)) {
            this.setEnabled(true);
        }
    }

    @Override
    public void listCommands(Vector<String> list) {
        super.listCommands(list);
        if (this.command != null && !list.contains(this.command)) {
            list.add(this.command);
        }
    }
}

