/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Property;
import org.lwjgl.input.Keyboard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.co.stealthware.minecraft.StealthwareMod;
import uk.co.stealthware.scg.command.CommandListItem;
import uk.co.stealthware.scg.command.ListFileInfo;
import uk.co.stealthware.scg.command.ModFileInfo;
import uk.co.stealthware.scg.gui.GuiLoading;
import uk.co.stealthware.scg.gui.GuiServerCommand;

@Mod(modid="SCG", name="Server Command GUI", version="2.1", useMetadata=true)
public class ServerCommands
extends StealthwareMod {
    public static String commandPrefix = "/";
    public static KeyBinding keyCommandMenu = new KeyBinding("key.servercommand", 46, "key.categories.multiplayer");
    public static ServerCommands instance;
    private boolean fetchingCommandList;
    private String serverType;
    private String fileOverride;
    private boolean ready = false;
    public CommandListItem commandList;
    private boolean lastCommandFound = false;
    private String langCode = "en_US";

    public ServerCommands() throws Exception {
        instance = this;
        this.fetchingCommandList = false;
        this.commandList = null;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        Property prop = this.config.get("general", "CommandFile", "AUTO");
        prop.comment = "This allows you to override which file is used to load the command list. (AUTO, scg_vanilla.xml, scg_bukkit.xml, or other file in config folder)";
        String temp = prop.getString();
        if (!temp.toUpperCase().equals("AUTO")) {
            this.fileOverride = temp;
        }
        this.config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        ClientRegistry.registerKeyBinding((KeyBinding)keyCommandMenu);
        this.langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        this.ready = false;
        this.commandList = null;
        if (!this.IsReady() && !this.fetchingCommandList) {
            this.Load();
        }
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent e) {
        if (keyCommandMenu.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r != null || !this.IsReady()) {
                return;
            }
            mc.field_71456_v.func_146158_b().func_146231_a();
            mc.func_147108_a((GuiScreen)new GuiServerCommand(this));
        }
    }

    public boolean IsReady() {
        return this.ready;
    }

    public void enableCommand(String command) {
        if (this.commandList == null) {
            return;
        }
        this.commandList.enableMatchingCommands(command);
    }

    public void commandFound(String command) {
        if (this.commandList == null) {
            if (command != null && command.length() > 0) {
                this.lastCommandFound = true;
            }
        } else {
            this.enableCommand(command);
        }
    }

    private void disableCommands() {
        if (this.commandList == null) {
            return;
        }
        this.commandList.setEnabled(false);
    }

    private void Load() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                GuiLoading loading = new GuiLoading(instance);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)loading);
                loading.setStatus(I18n.func_135052_a((String)"gui.loadingcommands", (Object[])new Object[0]), -1);
                boolean ok = false;
                if (ServerCommands.this.fileOverride != null) {
                    ok = ServerCommands.this.loadFile(new File(Minecraft.func_71410_x().field_71412_D + "/config/" + ServerCommands.this.fileOverride));
                } else {
                    List commandLists = ServerCommands.this.findFiles();
                    for (ListFileInfo info : commandLists) {
                        ServerCommands.this.lastCommandFound = false;
                        loading.requestCommand(info.getDetectionCommand());
                        while (loading.isWaiting()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (!ServerCommands.this.lastCommandFound) continue;
                        ok = ServerCommands.this.loadFile(info.getConfigFile());
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (ok) {
                    loading.setStatus(I18n.func_135052_a((String)"gui.loadingmodcommands", (Object[])new Object[0]), -1);
                    List modLists = ServerCommands.this.findModFiles();
                    CommandListItem modCategory = new CommandListItem(I18n.func_135052_a((String)"gui.modlist", (Object[])new Object[0]));
                    boolean hasModCommands = false;
                    for (ModFileInfo info : modLists) {
                        CommandListItem modCommands;
                        if (!Loader.isModLoaded((String)info.getModId()) || (modCommands = ServerCommands.this.loadModFile(info)) == null) continue;
                        modCategory.addSubCommand(modCommands);
                        hasModCommands = true;
                    }
                    if (hasModCommands) {
                        ServerCommands.this.commandList.addSubCommand(modCategory);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    loading.setStatus(I18n.func_135052_a((String)"gui.checkpermissions", (Object[])new Object[0]), 0);
                    ServerCommands.this.disableCommands();
                    Vector<String> list = new Vector<String>();
                    ServerCommands.this.commandList.listCommands(list);
                    Vector<String> list2 = new Vector<String>();
                    for (String cmd : list) {
                        String first = cmd.substring(0, 1);
                        if (list2.contains(first)) continue;
                        list2.add(first);
                    }
                    int count = 0;
                    for (String cmd : list2) {
                        loading.requestCommand(cmd);
                        loading.setStatus(I18n.func_135052_a((String)"gui.checkpermissions", (Object[])new Object[0]), (int)((float)(++count) / (float)list2.size() * 100.0f));
                        while (loading.isWaiting()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    loading.setStatus(I18n.func_135052_a((String)"gui.checkpermissions", (Object[])new Object[0]), 100);
                }
                ServerCommands.this.loadComplete(ok);
            }
        };
        t.start();
    }

    private List<ListFileInfo> findFiles() {
        ArrayList<ListFileInfo> list = new ArrayList<ListFileInfo>();
        try {
            File[] files;
            File dir = new File(Minecraft.func_71410_x().field_71412_D + "/config/");
            if (!new File(Minecraft.func_71410_x().field_71412_D + "/config/scg_vanilla.xml").exists()) {
                dir = new File(Minecraft.func_71410_x().field_71412_D + "/../../source/SCG/config/");
            }
            for (File file : files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith("scg_") && filename.endsWith(".xml");
                }
            })) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(file);
                    Element docNode = doc.getDocumentElement();
                    String server = docNode.getAttribute("server");
                    String detect = docNode.getAttribute("detect");
                    int priority = Integer.parseInt(docNode.getAttribute("priority"));
                    ListFileInfo info = new ListFileInfo(server, file, detect, priority);
                    list.add(info);
                }
                catch (Exception e) {
                    System.err.println("####################  SCG  ####################");
                    System.err.println("########  Error loading file: " + file.getName() + "  ########");
                    e.printStackTrace();
                    System.err.println("####################  SCG  ####################");
                }
            }
        }
        catch (Exception e) {
            System.err.println("####################  SCG  ####################");
            System.err.println("########  Error loading config files!  ########");
            e.printStackTrace();
            System.err.println("####################  SCG  ####################");
        }
        Collections.sort(list, new Comparator<ListFileInfo>(){

            @Override
            public int compare(ListFileInfo o1, ListFileInfo o2) {
                int temp = o2.getPriority() - o1.getPriority();
                if (temp == 0) {
                    if (o1.checkLocale(ServerCommands.this.langCode)) {
                        return -1;
                    }
                    if (o2.checkLocale(ServerCommands.this.langCode)) {
                        return 1;
                    }
                }
                return temp;
            }
        });
        return list;
    }

    private List<ModFileInfo> findModFiles() {
        ArrayList<ModFileInfo> list = new ArrayList<ModFileInfo>();
        try {
            File[] files;
            File dir = new File(Minecraft.func_71410_x().field_71412_D + "/config/");
            if (!new File(Minecraft.func_71410_x().field_71412_D + "/config/scg_vanilla.xml").exists()) {
                dir = new File(Minecraft.func_71410_x().field_71412_D + "/../../source/SCG/config/");
            }
            for (File file : files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith("scgmod_") && filename.endsWith(".xml");
                }
            })) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(file);
                    Element docNode = doc.getDocumentElement();
                    String name = docNode.getAttribute("name");
                    String modid = docNode.getAttribute("modid");
                    ModFileInfo info = new ModFileInfo(name, modid, file);
                    list.add(info);
                }
                catch (Exception e) {
                    System.err.println("####################  SCG  ####################");
                    System.err.println("########  Error loading file: " + file.getName() + "  ########");
                    e.printStackTrace();
                    System.err.println("####################  SCG  ####################");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Collections.sort(list, new Comparator<ModFileInfo>(){

            @Override
            public int compare(ModFileInfo o1, ModFileInfo o2) {
                return o1.getModName().compareTo(o2.getModName());
            }
        });
        return list;
    }

    private boolean loadFile(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            this.serverType = doc.getDocumentElement().getAttribute("server");
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            this.commandList = new CommandListItem(nodeList);
            return true;
        }
        catch (Exception e) {
            System.err.println("####################  SCG  ####################");
            System.err.println("########  Error loading file: " + file.getName() + "  ########");
            e.printStackTrace();
            System.err.println("####################  SCG  ####################");
            return false;
        }
    }

    private CommandListItem loadModFile(ModFileInfo mod) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(mod.getConfigFile());
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            CommandListItem modCommands = new CommandListItem(nodeList);
            modCommands.setName(mod.getModName());
            return modCommands;
        }
        catch (Exception e) {
            System.err.println("####################  SCG  ####################");
            System.err.println("########  Error loading file: " + mod.getConfigFile().getName() + "  ########");
            e.printStackTrace();
            System.err.println("####################  SCG  ####################");
            return null;
        }
    }

    private void loadComplete(boolean successful) {
        this.ready = true;
        Minecraft.func_71410_x().func_147108_a(null);
        Minecraft.func_71410_x().func_71381_h();
        GuiNewChat gui = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        if (successful) {
            gui.func_146227_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"gui.scgloaded", (Object[])new Object[]{this.getModVersion()})));
            gui.func_146227_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"gui.openmenu", (Object[])new Object[]{Keyboard.getKeyName((int)keyCommandMenu.func_151463_i())})));
            gui.func_146227_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"gui.usingtype", (Object[])new Object[]{this.serverType})));
        } else {
            gui.func_146227_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"gui.scgnotavailable", (Object[])new Object[]{this.getModVersion()})));
        }
        this.fetchingCommandList = false;
    }
}

