/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandPart {
    private CommandPartType type;
    private String fixedCommandText;
    private int min;
    private int max;
    public Vector<String> selectNames;
    public Vector<String> selectValues;
    private String inputValue;

    public CommandPart(CommandPartType type) {
        this.type = type;
    }

    public CommandPart(String fixedCommandText) {
        this.type = CommandPartType.FixedText;
        this.fixedCommandText = fixedCommandText;
    }

    public CommandPart(Node min, Node max) {
        this.type = CommandPartType.Number;
        if (min != null) {
            this.min = Integer.parseInt(min.getNodeValue());
        }
        if (max != null) {
            this.max = Integer.parseInt(max.getNodeValue());
        }
    }

    public CommandPart(NodeList nodes) {
        this.type = CommandPartType.Select;
        this.selectNames = new Vector();
        this.selectValues = new Vector();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || node.getNodeName() != "option") continue;
            String value = node.getFirstChild().getNodeValue();
            Node nameAttribute = node.getAttributes().getNamedItem("name");
            String name = nameAttribute != null ? nameAttribute.getNodeValue() : value;
            this.selectNames.add(name);
            this.selectValues.add(value);
        }
    }

    public boolean NeedsInput() {
        return this.type != CommandPartType.FixedText && this.inputValue == null;
    }

    public String toString() {
        switch (this.type) {
            case Text: {
                return this.inputValue;
            }
            case Number: {
                return this.inputValue;
            }
            case Player: {
                return this.inputValue;
            }
            case IPAddress: {
                return this.inputValue;
            }
            case Select: {
                return this.inputValue;
            }
            case Item: {
                return this.inputValue;
            }
            case FixedText: {
                return this.fixedCommandText;
            }
        }
        return "";
    }

    public CommandPartType getType() {
        return this.type;
    }

    public void setType(CommandPartType type) {
        this.type = type;
    }

    public boolean setInput(String inputText) {
        this.inputValue = inputText;
        return true;
    }

    public void clear() {
        this.inputValue = null;
    }

    public static enum CommandPartType {
        Text,
        Number,
        Player,
        IPAddress,
        Select,
        Item,
        FixedText,
        PlayerCustom;

    }
}

