/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import java.util.List;
import java.util.Vector;

public class CommandListItem {
    private boolean enabled;
    private String name;
    private String help;
    protected List<CommandListItem> subCommands;

    public boolean isEnabled() {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                if (!sub.isEnabled()) continue;
                return true;
            }
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                sub.setEnabled(enabled);
            }
        } else {
            this.enabled = enabled;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void addSubCommand(CommandListItem command) {
        if (this.subCommands == null) {
            this.subCommands = new Vector<CommandListItem>();
        }
        this.subCommands.add(command);
    }

    public boolean hasSubCommands() {
        return this.subCommands != null && this.countSubCommands() > 0;
    }

    public CommandListItem getSubCommand(int index) {
        int count = 0;
        for (CommandListItem sub : this.subCommands) {
            if (!sub.isEnabled()) continue;
            if (count == index) {
                return sub;
            }
            ++count;
        }
        return null;
    }

    public int countSubCommands() {
        int count = 0;
        for (CommandListItem sub : this.subCommands) {
            if (!sub.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public void enableMatchingCommands(String part) {
        if (this.subCommands != null) {
            for (CommandListItem sub : this.subCommands) {
                sub.enableMatchingCommands(part);
            }
        }
    }
}

