/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import java.util.Vector;
import uk.co.stealthware.scg.CommandListItem;
import uk.co.stealthware.scg.CommandPart;

public class Command
extends CommandListItem {
    public Vector<CommandPart> parts;

    public String getCommand() {
        StringBuilder sb = new StringBuilder();
        for (CommandPart item : this.parts) {
            sb.append(item.toString());
        }
        return sb.toString().trim();
    }

    public boolean NeedsInput() {
        return this.getNextCommandPart() != null;
    }

    public void addCommandPart(CommandPart commandPart) {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        this.parts.add(commandPart);
    }

    public CommandPart getNextCommandPart() {
        if (this.parts != null) {
            for (CommandPart item : this.parts) {
                if (!item.NeedsInput()) continue;
                return item;
            }
        }
        return null;
    }

    public void clearInput() {
        for (CommandPart item : this.parts) {
            item.clear();
        }
    }

    @Override
    public void enableMatchingCommands(String part) {
        super.enableMatchingCommands(part);
        if (this.parts != null && this.parts.get(0).getType() == CommandPart.CommandPartType.FixedText && this.parts.get(0).toString().startsWith(part)) {
            this.setEnabled(true);
        }
    }
}

