/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import uk.co.stealthware.minecraft.ModVersionChecker;

public abstract class StealthwareMod
implements IPlayerTracker {
    protected Configuration config;
    private boolean checkVersion = true;
    private ModVersionChecker mvc;

    protected StealthwareMod() {
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.checkVersion = this.config_getEnabled("ModVersionChecker", "true to enable automatic checking for new mod versions", this.checkVersion);
        if (this.checkVersion) {
            this.mvc = new ModVersionChecker(this);
        }
    }

    public void init(FMLInitializationEvent event) {
        if (this.checkVersion) {
            this.mvc.load();
            GameRegistry.registerPlayerTracker((IPlayerTracker)this);
        }
    }

    public String getName() {
        return this.getClass().getAnnotation(Mod.class).modid();
    }

    public String getFriendlyName() {
        return this.getClass().getAnnotation(Mod.class).name();
    }

    public String getUrl() {
        return FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata().url;
    }

    public String getModVersion() {
        return this.getClass().getAnnotation(Mod.class).version();
    }

    public String getMinecraftVersion() {
        return "1.6.2";
    }

    public String getFullVersion() {
        return this.getModVersion() + " [" + this.getMinecraftVersion() + "]";
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (this.checkVersion) {
            this.mvc.check();
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }

    protected int config_getBlockId(String name, int defaultId) {
        return this.config.get("block", name, defaultId).getInt();
    }

    protected int config_getItemId(String name, int defaultId) {
        return this.config.get("item", name, defaultId).getInt();
    }

    protected int config_getEntityId(String name, int defaultId) {
        return this.config.get("entity", name, defaultId).getInt();
    }

    protected boolean config_getEnabled(String name, String comment, boolean defaultValue) {
        Property prop = this.config.get("general", "Enable_" + name, defaultValue);
        prop.comment = comment;
        return prop.getBoolean(defaultValue);
    }

    protected int config_getRangeValue(String name, String comment, int defaultValue, int min, int max) {
        Property prop = this.config.get("general", name, defaultValue);
        prop.comment = comment + " (valid range: " + min + "-" + max + ")";
        int value = prop.getInt();
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }
}

