/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import org.lwjgl.input.Keyboard;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.stealthware.minecraft.StealthwareMod;
import uk.co.stealthware.scg.Command;
import uk.co.stealthware.scg.CommandListItem;
import uk.co.stealthware.scg.CommandPart;
import uk.co.stealthware.scg.KeyHandler;
import uk.co.stealthware.scg.TickHandler;

@Mod(modid="SCG", name="Server Commands GUI", version="1.5", useMetadata=true)
public class ServerCommands
extends StealthwareMod {
    public static String serverType = "auto";
    public static boolean enableModVersionChecker = true;
    public static KeyBinding keyCommandMenu = new KeyBinding("Server Commands", 46);
    private boolean fetchingCommandList;
    public CommandListItem commandList;
    private int updateCounter;
    String helpCommand = "/help";
    String currentServerType;
    public Vector players;
    boolean ready = false;
    private Vector responseBuffer;
    public static boolean WaitingForResponse = false;
    private static ServerCommands instance;

    public ServerCommands() throws Exception {
        instance = this;
        this.fetchingCommandList = false;
        this.updateCounter = 0;
        this.commandList = new CommandListItem();
        this.players = new Vector();
        this.responseBuffer = new Vector();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property prop = config.get("general", "Enable_ModVersionChecker", enableModVersionChecker);
        prop.comment = "true to enable automatic checking for new mod versions";
        enableModVersionChecker = prop.getBoolean(enableModVersionChecker);
        this.enableVersionCheck(enableModVersionChecker);
        prop = config.get("general", "ServerType", serverType);
        prop.comment = "This effects which command list is used. (auto, vanilla, simpleserver)";
        serverType = prop.getString();
        config.save();
    }

    @Override
    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        super.load(evt);
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyHandler(this, new KeyBinding[]{keyCommandMenu}, new boolean[]{false}));
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(this), (Side)Side.CLIENT);
    }

    private Boolean LoadFile() {
        try {
            File file = new File(Minecraft.func_71380_b() + "/config/", "scg_" + this.currentServerType + ".xml");
            if (!file.exists()) {
                file = new File(Minecraft.func_71380_b() + "/../../source/SCG/config/", "scg_" + this.currentServerType + ".xml");
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            this.currentServerType = doc.getDocumentElement().getAttribute("server");
            this.helpCommand = doc.getDocumentElement().getAttribute("helpCommand");
            NodeList nodeLst = doc.getDocumentElement().getChildNodes();
            this.LoadCommandList(nodeLst, this.commandList);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void LoadCommandList(NodeList nodeLst, CommandListItem parent) {
        for (int i = 0; i < nodeLst.getLength(); ++i) {
            Node node = nodeLst.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName() == "category") {
                CommandListItem category = new CommandListItem();
                this.LoadSharedAttributes(node, category);
                parent.addSubCommand(category);
                this.LoadCommandList(node.getChildNodes(), category);
                continue;
            }
            if (node.getNodeName() != "command") continue;
            Command command = new Command();
            this.LoadSharedAttributes(node, command);
            Node fstCldNode = node.getFirstChild();
            if (fstCldNode.getNodeType() == 3 && fstCldNode.getTextContent().trim().length() == 0) {
                fstCldNode = fstCldNode.getNextSibling();
            }
            if (fstCldNode.getNodeType() == 1 && (fstCldNode.getNodeName() == "category" || fstCldNode.getNodeName() == "command")) {
                parent.addSubCommand(command);
                this.LoadCommandList(node.getChildNodes(), command);
                continue;
            }
            if (fstCldNode.getNodeType() == 1 && (fstCldNode.getNodeName() == "select" || fstCldNode.getNodeName() == "number")) {
                this.LoadCommandParameters(node.getChildNodes(), command, parent);
                continue;
            }
            if (fstCldNode.getNodeType() != 3) continue;
            this.LoadCommandParameters(node.getChildNodes(), command, parent);
        }
    }

    private void LoadCommandParameters(NodeList nodes, Command command, CommandListItem parent) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName() == "text") {
                    command.addCommandPart(new CommandPart(CommandPart.CommandPartType.Text));
                    continue;
                }
                if (node.getNodeName() == "number") {
                    NamedNodeMap attrib = node.getAttributes();
                    command.addCommandPart(new CommandPart(attrib.getNamedItem("min"), attrib.getNamedItem("max")));
                    continue;
                }
                if (node.getNodeName() == "player") {
                    command.addCommandPart(new CommandPart(CommandPart.CommandPartType.Player));
                    continue;
                }
                if (node.getNodeName() == "ip") {
                    command.addCommandPart(new CommandPart(CommandPart.CommandPartType.IPAddress));
                    continue;
                }
                if (node.getNodeName() == "select") {
                    command.addCommandPart(new CommandPart(node.getChildNodes()));
                    continue;
                }
                if (node.getNodeName() != "item") continue;
                command.addCommandPart(new CommandPart(CommandPart.CommandPartType.Item));
                continue;
            }
            if (node.getNodeType() != 3) continue;
            command.addCommandPart(new CommandPart(node.getNodeValue()));
        }
        parent.addSubCommand(command);
    }

    private void LoadSharedAttributes(Node node, CommandListItem cli) {
        Node nameAttribute = node.getAttributes().getNamedItem("name");
        Node helpAttribute = node.getAttributes().getNamedItem("help");
        cli.setName(nameAttribute.getNodeValue());
        if (helpAttribute != null) {
            cli.setHelp(helpAttribute.getNodeValue());
        }
    }

    public KeyBinding getKeyCommandMenu() {
        return keyCommandMenu;
    }

    public boolean IsReady() {
        return this.ready;
    }

    public boolean onTickInGame() {
        if (enableModVersionChecker) {
            // empty if block
        }
        if (this.IsReady()) {
            return false;
        }
        if (!this.IsReady() && !this.fetchingCommandList) {
            this.Load();
            return true;
        }
        if (this.updateCounter > 100) {
            if (this.fetchingCommandList && this.responseBuffer.size() > 0) {
                Boolean ok;
                if (((String)this.responseBuffer.get(0)).indexOf("Available Commands:") >= 0) {
                    this.currentServerType = "simpleserver";
                    ok = this.LoadFile();
                    this.EnableCommands(this.responseBuffer);
                } else {
                    this.currentServerType = "vanilla";
                    ok = this.LoadFile();
                    this.commandList.setEnabled(true);
                }
                this.LoadComplete(ok);
            } else {
                this.LoadComplete(false);
            }
            return false;
        }
        ++this.updateCounter;
        return true;
    }

    private void EnableCommands(Vector helpString) {
        this.commandList.setEnabled(false);
        for (String line : helpString) {
            StringTokenizer tokeniser = new StringTokenizer(line);
            while (tokeniser.hasMoreTokens()) {
                String part = tokeniser.nextToken().replaceAll("\u00a7f", "");
                if (!part.startsWith("/")) continue;
                this.commandList.enableMatchingCommands(part);
            }
        }
    }

    public boolean onTickInGUI(GuiScreen guiscreen) {
        if (guiscreen instanceof GuiMainMenu) {
            this.ready = false;
            this.commandList = new CommandListItem();
        }
        return true;
    }

    private void LoadComplete(boolean successful) {
        this.ready = true;
        GuiNewChat gui = ModLoader.getMinecraftInstance().field_71456_v.func_73827_b();
        if (successful) {
            gui.func_73765_a("SCG v" + this.getModVersion() + " loaded");
            gui.func_73765_a("Press " + Keyboard.getKeyName((int)ServerCommands.keyCommandMenu.field_74512_d) + " to open menu");
            gui.func_73765_a("Using " + this.currentServerType + " commands");
        } else {
            gui.func_73765_a("SCG v" + this.getModVersion() + " not available");
        }
        WaitingForResponse = false;
        this.fetchingCommandList = false;
        this.responseBuffer.clear();
        this.updateCounter = 0;
    }

    private void Load() {
        if (serverType.equals("auto")) {
            WaitingForResponse = true;
            this.fetchingCommandList = true;
            ModLoader.getMinecraftInstance().field_71439_g.func_71165_d(this.helpCommand);
        } else {
            this.currentServerType = serverType;
            this.LoadFile();
            this.commandList.setEnabled(true);
            this.LoadComplete(true);
        }
    }

    public void GetPlayerList() {
        NetClientHandler netclienthandler = ModLoader.getMinecraftInstance().field_71439_g.field_71174_a;
        List list = netclienthandler.field_72559_c;
        this.players.clear();
        for (int i = 0; i < list.size(); ++i) {
            GuiPlayerInfo guiplayerinfo = (GuiPlayerInfo)list.get(i);
            this.players.add(this.stripColourCodes(guiplayerinfo.field_78831_a));
        }
    }

    private String stripColourCodes(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void handleResponseInternal(String message) {
        if (WaitingForResponse) {
            if (this.fetchingCommandList) {
                this.responseBuffer.add(message);
            } else {
                WaitingForResponse = false;
            }
        }
    }

    public static void handleResponse(String message) {
        if (instance != null) {
            instance.handleResponseInternal(message);
        }
    }
}

