/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.scg;

import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import uk.co.stealthware.scg.Command;
import uk.co.stealthware.scg.CommandListItem;
import uk.co.stealthware.scg.CommandPart;
import uk.co.stealthware.scg.ServerCommands;

public class GuiServerCommand
extends GuiScreen {
    private String screenTitle;
    private int updateCounter;
    private int selectedLine;
    private CommandListItem selectedCommand;
    private ServerCommands mod;
    private CommandPart currentPart;
    private String inputText = null;
    private static final String allowedCharacters = ChatAllowedCharacters.field_71568_a;
    private boolean inputMode = false;
    private Vector inputList;

    public GuiServerCommand(ServerCommands mod) {
        this.mod = mod;
        this.screenTitle = "Server Commands";
        this.selectedLine = 0;
        this.selectedCommand = mod.commandList;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.mod.GetPlayerList();
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        ++this.updateCounter;
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            this.field_73882_e.func_71373_a(null);
            this.field_73882_e.func_71381_h();
        } else if (i == 200) {
            --this.selectedLine;
            if (this.inputMode) {
                if (this.selectedLine < 0) {
                    this.selectedLine = this.inputList.size() - 1;
                }
            } else if (this.selectedLine < 0) {
                this.selectedLine = this.selectedCommand.countSubCommands() - 1;
            }
        } else if (i == 208) {
            ++this.selectedLine;
            if (this.inputMode) {
                if (this.selectedLine >= this.inputList.size()) {
                    this.selectedLine = 0;
                }
            } else if (this.selectedLine >= this.selectedCommand.countSubCommands()) {
                this.selectedLine = 0;
            }
        } else if (i == 205) {
            if (!this.inputMode && this.selectedCommand.getSubCommand(this.selectedLine).hasSubCommands()) {
                this.selectedCommand = this.selectedCommand.getSubCommand(this.selectedLine);
                this.selectedLine = 0;
            }
        } else if (i == 203) {
            if (!this.inputMode) {
                this.selectedCommand = this.mod.commandList;
                this.selectedLine = 0;
            }
        } else if (i == 28) {
            if (this.selectedCommand.getClass() == Command.class && ((Command)this.selectedCommand).NeedsInput()) {
                boolean inputOk = false;
                if (this.currentPart.getType() == CommandPart.CommandPartType.Player) {
                    if (this.selectedLine == this.inputList.size() - 1) {
                        this.currentPart.setType(CommandPart.CommandPartType.PlayerCustom);
                    } else {
                        inputOk = this.currentPart.setInput((String)this.mod.players.get(this.selectedLine));
                    }
                } else if (this.currentPart.getType() == CommandPart.CommandPartType.Select) {
                    inputOk = this.currentPart.setInput((String)this.currentPart.selectValues.get(this.selectedLine));
                } else {
                    inputOk = this.currentPart.setInput(this.inputText);
                    if (this.currentPart.getType() == CommandPart.CommandPartType.PlayerCustom) {
                        this.currentPart.setType(CommandPart.CommandPartType.Player);
                    }
                }
                if (inputOk) {
                    if (((Command)this.selectedCommand).NeedsInput()) {
                        this.currentPart = ((Command)this.selectedCommand).getNextCommandPart();
                        this.inputText = "";
                        this.selectedLine = 0;
                    } else {
                        this.inputText = null;
                        this.inputMode = false;
                        this.field_73882_e.field_71439_g.func_71165_d(((Command)this.selectedCommand).getCommand());
                        ((Command)this.selectedCommand).clearInput();
                        this.field_73882_e.func_71373_a(null);
                        this.field_73882_e.func_71381_h();
                    }
                    return;
                }
                return;
            }
            if (this.selectedCommand.getSubCommand(this.selectedLine).hasSubCommands()) {
                this.selectedCommand = this.selectedCommand.getSubCommand(this.selectedLine);
                this.selectedLine = 0;
            } else if (this.selectedCommand.getSubCommand(this.selectedLine).getClass() == Command.class) {
                if (((Command)this.selectedCommand.getSubCommand(this.selectedLine)).NeedsInput()) {
                    this.selectedCommand = this.selectedCommand.getSubCommand(this.selectedLine);
                    this.selectedLine = 0;
                    this.currentPart = ((Command)this.selectedCommand).getNextCommandPart();
                    this.inputText = "";
                    this.inputMode = true;
                } else {
                    String command = ((Command)this.selectedCommand.getSubCommand(this.selectedLine)).getCommand();
                    this.field_73882_e.field_71439_g.func_71165_d(command);
                    this.field_73882_e.func_71373_a(null);
                    this.field_73882_e.func_71381_h();
                }
            }
        } else if (this.inputText != null) {
            if (i == 14 && this.inputText.length() > 0) {
                this.inputText = this.inputText.substring(0, this.inputText.length() - 1);
            }
            if (allowedCharacters.indexOf(c) >= 0 && this.inputText.length() < 100) {
                this.inputText = this.inputText + c;
            }
        }
    }

    public void func_73863_a(int i, int j, float f) {
        if (this.mod.IsReady()) {
            if (this.selectedCommand.getClass() == Command.class && ((Command)this.selectedCommand).NeedsInput() && this.currentPart != null) {
                if (this.currentPart.getType() == CommandPart.CommandPartType.Player) {
                    Vector<String> temp = new Vector<String>(this.mod.players);
                    temp.add("Enter Name...");
                    this.drawInputList(this.selectedCommand.getName(), temp);
                } else if (this.currentPart.getType() == CommandPart.CommandPartType.Select) {
                    this.drawInputList(this.selectedCommand.getName(), this.currentPart.selectNames);
                } else {
                    int blockHeight = 25;
                    GuiServerCommand.func_73734_a((int)5, (int)(this.field_73881_g - blockHeight), (int)100, (int)(this.field_73881_g - 5), (int)Integer.MIN_VALUE);
                    String title = this.selectedCommand.getName();
                    this.func_73731_b(this.field_73886_k, title, 5, this.field_73881_g - blockHeight - 10, 0xE0E0E0);
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.inputText);
                    int colour = 0xE0E0E0;
                    if (this.updateCounter / 6 % 2 == 0) {
                        sb.append("_");
                    }
                    this.func_73731_b(this.field_73886_k, sb.toString(), 10, this.field_73881_g - blockHeight + 5, colour);
                }
            } else {
                int blockHeight = 10 * this.selectedCommand.countSubCommands() + 15;
                GuiServerCommand.func_73734_a((int)5, (int)(this.field_73881_g - blockHeight), (int)100, (int)(this.field_73881_g - 5), (int)Integer.MIN_VALUE);
                String title = this.selectedCommand.getName();
                if (title == null) {
                    title = this.screenTitle;
                }
                this.func_73731_b(this.field_73886_k, title, 5, this.field_73881_g - blockHeight - 10, 0xE0E0E0);
                for (int idx = 0; idx < this.selectedCommand.countSubCommands(); ++idx) {
                    int colour = 0xE0E0E0;
                    if (this.selectedLine == idx) {
                        colour = this.updateCounter / 6 % 2 != 0 ? 0xA0A0E0 : 0x6060E0;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.selectedCommand.getSubCommand(idx).getName());
                    if (this.selectedCommand.getSubCommand(idx).hasSubCommands()) {
                        sb.append(">");
                    }
                    this.func_73731_b(this.field_73886_k, sb.toString(), 10, this.field_73881_g - blockHeight + 5 + 10 * idx, colour);
                }
            }
        } else {
            if (this.updateCounter > 40) {
                this.field_73882_e.func_71373_a(null);
                this.field_73882_e.func_71381_h();
                return;
            }
            int blockHeight = 25;
            GuiServerCommand.func_73734_a((int)5, (int)(this.field_73881_g - blockHeight), (int)100, (int)(this.field_73881_g - 5), (int)Integer.MIN_VALUE);
            this.func_73731_b(this.field_73886_k, this.screenTitle, 8, this.field_73881_g - blockHeight - 10, 0xE0E0E0);
            this.func_73731_b(this.field_73886_k, "Not Available", 10, this.field_73881_g - blockHeight + 5, 0xE0E0E0);
        }
        super.func_73863_a(i, j, f);
    }

    private void drawInputList(String title, Vector list) {
        this.inputList = list;
        int blockHeight = 10 * list.size() + 15;
        GuiServerCommand.func_73734_a((int)5, (int)(this.field_73881_g - blockHeight), (int)100, (int)(this.field_73881_g - 5), (int)Integer.MIN_VALUE);
        this.func_73731_b(this.field_73886_k, title, 5, this.field_73881_g - blockHeight - 10, 0xE0E0E0);
        for (int idx = 0; idx < list.size(); ++idx) {
            int colour = 0xE0E0E0;
            if (this.selectedLine == idx) {
                colour = this.updateCounter / 6 % 2 != 0 ? 0xA0A0E0 : 0x6060E0;
            }
            StringBuilder sb = new StringBuilder();
            sb.append((String)list.get(idx));
            this.func_73731_b(this.field_73886_k, sb.toString(), 10, this.field_73881_g - blockHeight + 5 + 10 * idx, colour);
        }
    }
}

