/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import uk.co.stealthware.minecraft.StealthwareMod;

public class ModVersionChecker {
    private File cfgdir;
    private StealthwareMod mod;
    private String modName;
    private String modFriendlyName;
    private String modVersion;
    private Date lastCheck;
    private boolean checkCalled;

    public ModVersionChecker(StealthwareMod mod) {
        try {
            this.cfgdir = new File(Minecraft.func_71380_b(), "/config/");
        }
        catch (NoClassDefFoundError e) {
            this.cfgdir = new File("/config/");
        }
        this.mod = mod;
        this.modName = mod.getName();
        this.modFriendlyName = mod.getFriendlyName();
        this.modVersion = mod.getFullVersion();
        this.lastCheck = null;
        this.checkCalled = false;
    }

    public void load() {
        this.loadConfig();
    }

    private void loadConfig() {
        try {
            String value;
            Properties properties = new Properties();
            File file = new File(this.cfgdir, this.modName + ".internal.cfg");
            if (file.exists() && file.canRead()) {
                properties.load(new FileInputStream(file));
            }
            if ((value = properties.getProperty("LastCheckDate")) != null) {
                this.lastCheck = DateFormat.getDateInstance(3).parse(value);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void saveConfig() {
        try {
            Properties properties = new Properties();
            File file = new File(this.cfgdir, this.modName + ".internal.cfg");
            if (file.exists() && file.canRead()) {
                properties.load(new FileInputStream(file));
            }
            properties.setProperty("LastCheckDate", DateFormat.getDateInstance(3).format(this.lastCheck));
            if (!properties.isEmpty() && (file.exists() || file.createNewFile()) && file.canWrite()) {
                properties.store(new FileOutputStream(file), "");
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void check() {
        if (this.checkCalled) {
            return;
        }
        this.checkCalled = true;
        if (this.lastCheck != null) {
            Calendar today = Calendar.getInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.lastCheck);
            if (cal.get(1) == today.get(1) && cal.get(2) == today.get(2) && cal.get(5) == today.get(5)) {
                return;
            }
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                String latest = ModVersionChecker.this.getLatestVersion();
                ModVersionChecker.this.lastCheck = new Date();
                ModVersionChecker.this.saveConfig();
                if (latest != null && !latest.equals(ModVersionChecker.this.modVersion)) {
                    String message = ModVersionChecker.this.modFriendlyName + " has been updated to " + latest;
                    String url = ModVersionChecker.this.mod.getUrl();
                    if (url != null && url.length() > 0) {
                        message = message + "\nVisit " + ModVersionChecker.this.mod.getUrl() + " to download";
                    }
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    server.func_71244_g(message);
                    for (EntityPlayerMP var6 : server.func_71203_ab().field_72404_b) {
                        if (!server.func_71203_ab().func_72353_e(var6.field_71092_bJ)) continue;
                        var6.func_70006_a("\u00a77" + message);
                    }
                }
            }
        };
        t.start();
    }

    private String getLatestVersion() {
        try {
            String name = null;
            String version = null;
            HttpURLConnection conn = (HttpURLConnection)new URL("http://stealthware.co.uk/api/version.php?q=" + this.modName).openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/6.0 (Windows NT 6.2; WOW64; rv:16.0.1) Gecko/20121011 Firefox/16.0.1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                if (temp.startsWith("Name=")) {
                    name = temp.substring(5);
                    continue;
                }
                if (!temp.startsWith("Version=")) continue;
                version = temp.substring(8);
            }
            reader.close();
            conn.disconnect();
            return version;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getModVersion(String ver) {
        int pos = ver.indexOf(32);
        return ver.substring(0, pos);
    }

    public static String getMinecraftVersion(String ver) {
        int pos = ver.indexOf(91);
        int pos2 = ver.indexOf(93);
        return ver.substring(pos + 1, pos2);
    }
}

