/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.moremeat.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import uk.co.stealthware.minecraft.StealthwareMod;
import uk.co.stealthware.moremeat.MoreMeat2;
import uk.co.stealthware.moremeat.entity.CapturedEntity;
import uk.co.stealthware.moremeat.entity.TileEntityMeatMachine;

public class BlockMeatMachine
extends BlockContainer {
    StealthwareMod mod;
    public static BlockMeatMachine instance;
    public Vector<CapturedEntity> capturedEntities;
    public Vector<ChunkPosition> serverCaptures;
    private Random rand;
    public Item itemGelatine;
    private IIcon texSide;
    private IIcon texTop_empty;
    private IIcon texTop_med;
    private IIcon texTop_full;
    private IIcon texTop_off;

    public BlockMeatMachine(StealthwareMod mod) {
        super(Material.field_151576_e);
        this.mod = mod;
        instance = this;
        this.func_149711_c(3.5f);
        this.func_149672_a(field_149769_e);
        this.capturedEntities = new Vector();
        this.serverCaptures = new Vector();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.rand = new Random();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_base");
        this.texSide = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_side");
        this.texTop_empty = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_empty");
        this.texTop_med = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_med");
        this.texTop_full = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_full");
        this.texTop_off = par1IconRegister.func_94245_a("MoreMeat2:meatMachine_off");
    }

    public IIcon func_149691_a(int i, int j) {
        if (i == 1) {
            if (j == 0) {
                return this.texTop_empty;
            }
            if (j == 1) {
                return this.texTop_med;
            }
            if (j == 2) {
                return this.texTop_full;
            }
            return this.texTop_off;
        }
        if (i == 0) {
            return this.field_149761_L;
        }
        return this.texSide;
    }

    public void func_149724_b(World world, int i, int j, int k, Entity entity) {
        MoreMeat2.proxy.CheckEntity(this, world, entity, i, j, k);
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        MoreMeat2.proxy.CheckEntity(this, world, entity, i, j, k);
    }

    @SubscribeEvent
    public void entityDeath(LivingDropsEvent event) {
        if (this.capturedEntities.size() > 0) {
            CapturedEntity captured = null;
            for (CapturedEntity ce : this.capturedEntities) {
                if (event.entityLiving != ce.getEntity()) continue;
                captured = ce;
                break;
            }
            if (captured != null) {
                try {
                    for (EntityItem item : event.drops) {
                        ItemStack stack = item.func_92059_d();
                        if (MoreMeat2.enableMeatMachineCooking) {
                            ItemStack cooked = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                            if (cooked != null) {
                                this.addToInventory(captured.getMeatMachine(), new ItemStack(cooked.func_77973_b(), stack.field_77994_a));
                                continue;
                            }
                            this.addToInventory(captured.getMeatMachine(), stack);
                            continue;
                        }
                        this.addToInventory(captured.getMeatMachine(), stack);
                    }
                }
                catch (ConcurrentModificationException ex) {
                    System.out.println("MeatMachine CME");
                }
                if (captured.getEntity() instanceof EntityVillager) {
                    this.LootVillager((EntityVillager)captured.getEntity(), captured.getMeatMachine());
                } else if (!(captured.getEntity() instanceof EntityPlayer) && captured.getEntity() instanceof EntityEnderman && ((EntityEnderman)captured.getEntity()).func_70694_bm() != null) {
                    this.addToInventory(captured.getMeatMachine(), new ItemStack(((EntityEnderman)captured.getEntity()).func_70694_bm().func_77973_b(), 1, ((EntityEnderman)captured.getEntity()).func_70824_q()));
                }
                if (this.rand.nextInt(2) == 0) {
                    if (this.itemGelatine != null && this.rand.nextInt(2) == 0) {
                        this.addToInventory(captured.getMeatMachine(), new ItemStack(this.itemGelatine, 1));
                    } else {
                        this.addToInventory(captured.getMeatMachine(), new ItemStack(Items.field_151103_aS, 1));
                    }
                }
                this.capturedEntities.remove(captured);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public void LootPlayer(EntityPlayer player, TileEntityMeatMachine meatMachine) {
        int var1;
        this.addToInventory(meatMachine, new ItemStack(MoreMeat2.itemMysteryMeat, 2));
        for (var1 = 0; var1 < player.field_71071_by.field_70462_a.length; ++var1) {
            if (player.field_71071_by.field_70462_a[var1] == null) continue;
            this.addToInventory(meatMachine, player.field_71071_by.field_70462_a[var1]);
            player.field_71071_by.field_70462_a[var1] = null;
        }
        for (var1 = 0; var1 < player.field_71071_by.field_70460_b.length; ++var1) {
            if (player.field_71071_by.field_70460_b[var1] == null) continue;
            this.addToInventory(meatMachine, player.field_71071_by.field_70460_b[var1]);
            player.field_71071_by.field_70460_b[var1] = null;
        }
        this.addToInventory(meatMachine, new ItemStack(MoreMeat2.itemXPball, 1, player.field_71068_ca));
    }

    private void LootVillager(EntityVillager entity, TileEntityMeatMachine meatMachine) {
        this.addToInventory(meatMachine, new ItemStack(MoreMeat2.itemMysteryMeat, 1));
        int profession = entity.func_70946_n();
        if (profession == 0) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151018_J, 1));
        } else if (profession == 1) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151122_aG, 1));
        } else if (profession == 2) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151034_e, 1));
        } else if (profession == 3) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151042_j, 1));
        } else if (profession == 4) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151157_am, 1));
        }
        if (this.rand.nextFloat() <= 0.5f) {
            this.addToInventory(meatMachine, new ItemStack(Items.field_151166_bC, 1));
        }
    }

    public void addToInventory(TileEntityMeatMachine meatMachine, ItemStack itemStack) {
        boolean done = false;
        for (int l = 0; l < meatMachine.func_70302_i_(); ++l) {
            ItemStack stk = meatMachine.func_70301_a(l);
            if (stk == null) {
                meatMachine.func_70299_a(l, itemStack);
                done = true;
                break;
            }
            if (!stk.func_77969_a(itemStack)) continue;
            while (stk.field_77994_a < stk.func_77976_d() && itemStack.field_77994_a > 0) {
                ++stk.field_77994_a;
                --itemStack.field_77994_a;
            }
            if (itemStack.field_77994_a != 0) continue;
            done = true;
            break;
        }
        if (!done) {
            World world = meatMachine.func_145831_w();
            float f1 = 0.7f;
            float f2 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f3 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f4 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)meatMachine.field_145851_c + f2), (double)((float)(meatMachine.field_145848_d + 1) + f3), (double)((float)meatMachine.field_145849_e + f4), itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        meatMachine.checkContainerSpace();
    }

    public TileEntity func_149915_a(World var1, int x) {
        return new TileEntityMeatMachine();
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntityMeatMachine obj = (TileEntityMeatMachine)world.func_147438_o(i, j, k);
        if (obj != null && !world.field_72995_K) {
            entityplayer.func_71007_a((IInventory)obj);
        }
        return true;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        TileEntityMeatMachine tileentitymm = (TileEntityMeatMachine)world.func_147438_o(i, j, k);
        if (tileentitymm != null && !world.field_72995_K) {
            for (int l = 0; l < tileentitymm.func_70302_i_(); ++l) {
                ItemStack itemstack = tileentitymm.func_70301_a(l);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int i1 = world.field_73012_v.nextInt(21) + 10;
                    if (i1 > itemstack.field_77994_a) {
                        i1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= i1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        this.func_149695_a(par1World, par2, par3, par4, (Block)this);
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        boolean powered = par1World.func_72864_z(par2, par3, par4);
        if (powered) {
            par1World.func_72921_c(par2, par3, par4, 3, 0);
        } else {
            par1World.func_72921_c(par2, par3, par4, 0, 0);
            TileEntity te = par1World.func_147438_o(par2, par3, par4);
            ((TileEntityMeatMachine)te).checkContainerSpace();
        }
    }

    public TileEntityMeatMachine getCapturingMachine(EntityLivingBase entity) {
        if (this.capturedEntities.size() > 0) {
            CapturedEntity captured = null;
            for (CapturedEntity ce : this.capturedEntities) {
                if (entity != ce.getEntity()) continue;
                captured = ce;
                break;
            }
            if (captured != null) {
                return captured.getMeatMachine();
            }
        }
        return null;
    }
}

