/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.moremeat;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import uk.co.stealthware.minecraft.StealthwareItem;
import uk.co.stealthware.minecraft.StealthwareMod;
import uk.co.stealthware.moremeat.CommonProxy;
import uk.co.stealthware.moremeat.Packet;
import uk.co.stealthware.moremeat.PacketHandler;
import uk.co.stealthware.moremeat.block.BlockMeatMachine;
import uk.co.stealthware.moremeat.block.BlockStrawBale;
import uk.co.stealthware.moremeat.entity.EntityWildBoar;
import uk.co.stealthware.moremeat.entity.OcelotHandler;
import uk.co.stealthware.moremeat.entity.TileEntityMeatMachine;
import uk.co.stealthware.moremeat.entity.WolfHandler;
import uk.co.stealthware.moremeat.item.ItemCreeperGoo;
import uk.co.stealthware.moremeat.item.ItemEnderMeat;
import uk.co.stealthware.moremeat.item.ItemFood;
import uk.co.stealthware.moremeat.item.ItemSeeds;
import uk.co.stealthware.moremeat.item.ItemStackableStew;
import uk.co.stealthware.moremeat.item.ItemXPBall;

@Mod(modid="MoreMeat2", name="MoreMeat 2", version="2.3", useMetadata=true)
public class MoreMeat2
extends StealthwareMod
implements IFuelHandler {
    public static int wildBoarEntityId = 84;
    public static boolean enableMeatMachine = true;
    public static boolean enableMeatMachineCooking = true;
    public static boolean enableMeatMachinePower = true;
    @SidedProxy(clientSide="uk.co.stealthware.moremeat.ClientProxy", serverSide="uk.co.stealthware.moremeat.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static BlockMeatMachine blockMeatMachine;
    public static Block blockStrawBale;
    public static Item itemXPball;
    public static Item itemRawLamb;
    public static Item itemRawMutton;
    public static Item itemMintyLambBurger;
    public static Item itemMuttonStew;
    public static Item itemRawSquid;
    public static Item itemCookedSquid;
    public static Item itemRawSpiderLeg;
    public static Item itemCookedSpiderLeg;
    public static Item itemRawWolf;
    public static Item itemCookedWolf;
    public static Item itemMysteryMeat;
    public static Item itemRawBoar;
    public static Item itemCookedBoar;
    public static Item itemRawEnder;
    public static Item itemCookedEnder;
    public static ItemCreeperGoo itemCreeperGoo;
    public static Item itemZombiePie;
    public static Item itemRawOcelot;
    public static Item itemCookedOcelot;
    public static Item itemRawHorseRib;
    public static Item itemCookedHorseRib;
    public static Item itemStraw;
    public static Item itemGrain;
    public static Item itemFlour;
    public static Item itemWhiteBread;
    public static Item itemWholegrainBread;
    public static Item itemTinCan;
    public static Item itemCannedMeat;
    public static Item itemDogFood;
    public static Item itemCatFood;
    public static int modelIdThatch;
    private Random rand = new Random();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        wildBoarEntityId = this.config_getEntityId("WildBoar", wildBoarEntityId);
        enableMeatMachine = this.config_getEnabled("MeatMachine", "true to allow use of the Meat Machine block", enableMeatMachine);
        enableMeatMachineCooking = this.config_getEnabled("MeatMachineCooking", "true to make the Meat Machine cook the items it collects", enableMeatMachineCooking);
        enableMeatMachinePower = this.config_getEnabled("MeatMachinePower", "true to allow the Meat Machine to be disabled by powering it with redstone", enableMeatMachinePower);
        this.config.save();
        if (enableMeatMachine) {
            blockMeatMachine = new BlockMeatMachine(this);
            itemXPball = new ItemXPBall(this);
        }
        blockStrawBale = new BlockStrawBale(this);
        itemRawLamb = new ItemFood(3, 0.3f, true, this);
        itemMintyLambBurger = new ItemFood(10, 0.8f, true, this);
        itemRawMutton = new ItemFood(3, 0.3f, true, this);
        itemMuttonStew = new ItemStackableStew(6, this);
        itemRawSquid = new ItemFood(3, 0.3f, true, this);
        itemCookedSquid = new ItemFood(8, 0.8f, true, this);
        itemRawSpiderLeg = new ItemFood(3, 0.3f, true, this);
        itemCookedSpiderLeg = new ItemFood(8, 0.8f, true, this);
        itemRawWolf = new ItemFood(3, 0.3f, true, this);
        itemCookedWolf = new ItemFood(8, 0.8f, true, this);
        itemMysteryMeat = new ItemFood(4, 0.4f, true, this);
        itemRawBoar = new ItemFood(3, 0.3f, true, this);
        itemCookedBoar = new ItemFood(8, 0.8f, true, this);
        itemRawEnder = new ItemEnderMeat(2, 0.2f, false, 0.9f, this);
        itemCookedEnder = new ItemEnderMeat(5, 0.5f, false, 0.6f, this);
        itemCreeperGoo = new ItemCreeperGoo(2, 0.3f, false, this);
        itemZombiePie = new ItemFood(8, 0.8f, false, this);
        itemRawOcelot = new ItemFood(3, 0.3f, true, this);
        itemCookedOcelot = new ItemFood(8, 0.8f, true, this);
        itemRawHorseRib = new ItemFood(3, 0.3f, true, this);
        itemCookedHorseRib = new ItemFood(8, 0.8f, true, this);
        itemStraw = new StealthwareItem((StealthwareMod)this);
        itemGrain = new ItemSeeds(Blocks.field_150464_aj, Blocks.field_150458_ak, this);
        itemFlour = new StealthwareItem((StealthwareMod)this);
        itemWhiteBread = new ItemFood(3, 0.6f, false, this);
        itemWholegrainBread = new ItemFood(4, 0.6f, false, this);
        itemTinCan = new StealthwareItem((StealthwareMod)this);
        itemCannedMeat = new ItemFood(16, 0.8f, true, this);
        itemDogFood = new ItemFood(1, 0.5f, false, this);
        itemCatFood = new ItemFood(1, 0.5f, false, this);
        if (enableMeatMachine) {
            this.registerBlock((Block)blockMeatMachine, "meatMachine");
            this.registerItem(itemXPball, "xpBall");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockMeatMachine, 1), (Object[])new Object[]{"ISI", "SRS", "SSS", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('R'), Items.field_151137_ax});
        }
        this.registerBlock(blockStrawBale, "strawBale");
        this.registerItem(itemRawLamb, "lambRaw");
        this.registerItem(itemMintyLambBurger, "lambBurger");
        this.registerItem(itemRawMutton, "muttonRaw");
        this.registerItem(itemMuttonStew, "muttonStew");
        this.registerItem(itemRawSquid, "squidRaw");
        this.registerItem(itemCookedSquid, "squidCooked");
        this.registerItem(itemRawSpiderLeg, "spiderLegRaw");
        this.registerItem(itemCookedSpiderLeg, "spiderLegCooked");
        this.registerItem(itemRawWolf, "wolfRaw");
        this.registerItem(itemCookedWolf, "wolfCooked");
        this.registerItem(itemMysteryMeat, "mysteryMeat");
        this.registerItem(itemRawBoar, "boarRaw");
        this.registerItem(itemCookedBoar, "boarCooked");
        this.registerItem(itemRawEnder, "enderRaw");
        this.registerItem(itemCookedEnder, "enderCooked");
        this.registerItem((Item)itemCreeperGoo, "creeperRaw");
        this.registerItem(itemZombiePie, "zombiePie");
        this.registerItem(itemRawOcelot, "ocelotRaw");
        this.registerItem(itemCookedOcelot, "ocelotCooked");
        this.registerItem(itemRawHorseRib, "horseRibRaw");
        this.registerItem(itemCookedHorseRib, "horseRibCooked");
        this.registerItem(itemStraw, "straw");
        this.registerItem(itemGrain, "grain");
        this.registerItem(itemFlour, "flour");
        this.registerItem(itemWhiteBread, "whiteBread");
        this.registerItem(itemWholegrainBread, "wholegrainBread");
        this.registerItem(itemTinCan, "tinCan");
        this.registerItem(itemCannedMeat, "cannedMeat");
        this.registerItem(itemDogFood, "dogFood");
        this.registerItem(itemCatFood, "catFood");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        network = new SimpleNetworkWrapper("MoreMeat_C1");
        network.registerMessage(PacketHandler.CaptureEntityHandler.class, Packet.CaptureEntity.class, 1, Side.CLIENT);
        network.registerMessage(PacketHandler.KillEntityHandler.class, Packet.KillEntity.class, 2, Side.CLIENT);
        network.registerMessage(PacketHandler.TeleportEffectsHandler.class, Packet.TeleportEffects.class, 3, Side.CLIENT);
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemMuttonStew), (Object[])new Object[]{"Y", "Y", "X", Character.valueOf('Y'), itemRawMutton, Character.valueOf('X'), Items.field_151054_z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemZombiePie, 2), (Object[])new Object[]{" A ", "BBB", "CCC", Character.valueOf('A'), Items.field_151102_aT, Character.valueOf('B'), Items.field_151078_bh, Character.valueOf('C'), itemFlour});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockStrawBale, 1), (Object[])new Object[]{"## ", "## ", Character.valueOf('#'), itemStraw});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemGrain, 1), (Object[])new Object[]{"#", Character.valueOf('#'), Items.field_151015_O});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemFlour, 1), (Object[])new Object[]{"#", Character.valueOf('#'), itemGrain});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151025_P, 1), (Object[])new Object[]{"###", Character.valueOf('#'), itemFlour});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151105_aU, 1), (Object[])new Object[]{"AAA", "BEB", "CCC", Character.valueOf('A'), Items.field_151117_aB, Character.valueOf('B'), Items.field_151102_aT, Character.valueOf('C'), itemFlour, Character.valueOf('E'), Items.field_151110_aK});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemWhiteBread, 1), (Object[])new Object[]{"#", "#", Character.valueOf('#'), itemFlour});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemWholegrainBread, 1), (Object[])new Object[]{"#", "X", Character.valueOf('#'), itemFlour, Character.valueOf('X'), itemGrain});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemTinCan, 32), (Object[])new Object[]{"# #", "# #", " # ", Character.valueOf('#'), Items.field_151042_j});
        this.addCannedMeatRecipes(new Item[]{Items.field_151083_be, Items.field_151157_am, Items.field_151101_aQ, Items.field_151077_bg, itemCookedWolf, itemCookedBoar, itemCookedOcelot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemDogFood, 1), (Object[])new Object[]{"B", "G", "#", Character.valueOf('B'), Items.field_151083_be, Character.valueOf('G'), itemGrain, Character.valueOf('#'), itemTinCan});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemCatFood, 1), (Object[])new Object[]{"C", "G", "#", Character.valueOf('C'), Items.field_151077_bg, Character.valueOf('G'), itemGrain, Character.valueOf('#'), itemTinCan});
        GameRegistry.addSmelting((Item)itemRawLamb, (ItemStack)new ItemStack(itemMintyLambBurger, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawSpiderLeg, (ItemStack)new ItemStack(itemCookedSpiderLeg, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawSquid, (ItemStack)new ItemStack(itemCookedSquid, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawWolf, (ItemStack)new ItemStack(itemCookedWolf, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawBoar, (ItemStack)new ItemStack(itemCookedBoar, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawEnder, (ItemStack)new ItemStack(itemCookedEnder, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawOcelot, (ItemStack)new ItemStack(itemCookedOcelot, 1), (float)0.3f);
        GameRegistry.addSmelting((Item)itemRawHorseRib, (ItemStack)new ItemStack(itemCookedHorseRib, 1), (float)0.3f);
        EntityRegistry.registerGlobalEntityID(EntityWildBoar.class, (String)"WildBoar", (int)wildBoarEntityId);
        if (enableMeatMachine) {
            GameRegistry.registerTileEntity(TileEntityMeatMachine.class, (String)"MeatMachine");
        }
        BiomeGenBase[] wildBoarBiomes = new BiomeGenBase[]{BiomeGenBase.field_76767_f, BiomeGenBase.field_76780_h};
        EntityRegistry.addSpawn(EntityWildBoar.class, (int)1, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])wildBoarBiomes);
        if (enableMeatMachine) {
            blockMeatMachine.func_149647_a(CreativeTabs.field_78028_d);
        }
        blockStrawBale.func_149647_a(CreativeTabs.field_78030_b);
        itemRawLamb.func_77637_a(CreativeTabs.field_78039_h);
        itemMintyLambBurger.func_77637_a(CreativeTabs.field_78039_h);
        itemRawMutton.func_77637_a(CreativeTabs.field_78039_h);
        itemMuttonStew.func_77637_a(CreativeTabs.field_78039_h);
        itemRawSquid.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedSquid.func_77637_a(CreativeTabs.field_78039_h);
        itemRawSpiderLeg.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedSpiderLeg.func_77637_a(CreativeTabs.field_78039_h);
        itemRawWolf.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedWolf.func_77637_a(CreativeTabs.field_78039_h);
        itemRawEnder.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedEnder.func_77637_a(CreativeTabs.field_78039_h);
        itemCreeperGoo.func_77637_a(CreativeTabs.field_78026_f);
        itemRawOcelot.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedOcelot.func_77637_a(CreativeTabs.field_78039_h);
        itemRawHorseRib.func_77637_a(CreativeTabs.field_78039_h);
        itemCookedHorseRib.func_77637_a(CreativeTabs.field_78039_h);
        itemZombiePie.func_77637_a(CreativeTabs.field_78039_h);
        itemStraw.func_77637_a(CreativeTabs.field_78035_l);
        itemGrain.func_77637_a(CreativeTabs.field_78039_h);
        itemFlour.func_77637_a(CreativeTabs.field_78039_h);
        itemWhiteBread.func_77637_a(CreativeTabs.field_78039_h);
        itemWholegrainBread.func_77637_a(CreativeTabs.field_78039_h);
        itemTinCan.func_77637_a(CreativeTabs.field_78035_l);
        itemCannedMeat.func_77637_a(CreativeTabs.field_78039_h);
        itemDogFood.func_77637_a(CreativeTabs.field_78039_h);
        itemCatFood.func_77637_a(CreativeTabs.field_78039_h);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Object explodables;
        Object neiAPI = evt.buildSoftDependProxy("NotEnoughItems", "codechicken.nei.api.API");
        if (neiAPI != null) {
            try {
                Method hideItem = neiAPI.getClass().getMethod("hideItem", Integer.TYPE);
                hideItem.invoke(neiAPI, Item.func_150891_b((Item)itemXPball));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((explodables = evt.buildSoftDependProxy("Explodables", "uk.co.stealthware.explodables.Explodables")) != null) {
            try {
                Item gelatine;
                Field itemField = explodables.getClass().getField("itemGelatine");
                MoreMeat2.blockMeatMachine.itemGelatine = gelatine = (Item)itemField.get(explodables);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addCannedMeatRecipes(Item[] meats) {
        for (int i = 0; i < meats.length; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCannedMeat, 1), (Object[])new Object[]{"#", "#", "X", Character.valueOf('#'), meats[i], Character.valueOf('X'), itemTinCan});
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent e) {
        if (e.player instanceof EntityPlayerMP && e.crafting.func_77973_b() == itemGrain) {
            World world = e.player.field_70170_p;
            EntityItem entityitem = new EntityItem(world, e.player.field_70165_t, e.player.field_70163_u, e.player.field_70161_v, new ItemStack(itemStraw));
            float f = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f;
            entityitem.field_145804_b = 20;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (enableMeatMachine) {
                proxy.updateMeatMachine(blockMeatMachine);
            }
            proxy.updateCreeperGoo();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (enableMeatMachine) {
                proxy.updateMeatMachine(blockMeatMachine);
            }
            proxy.updateCreeperGoo();
        }
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)fuel.func_77973_b()).field_150939_a;
            if (block == blockStrawBale || block == Blocks.field_150407_cf) {
                return 800;
            }
        } else if (fuel.func_77973_b() == itemStraw || fuel.func_77973_b() == Items.field_151015_O) {
            return 200;
        }
        return 0;
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        int looting;
        World world = event.entityLiving.field_70170_p;
        if (world.field_72995_K || !world.func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        int lootingModifier = 0;
        if (event.source instanceof EntityDamageSource && (looting = EnchantmentHelper.func_77519_f((EntityLivingBase)((EntityLivingBase)event.source.func_76346_g()))) > 0) {
            lootingModifier = this.rand.nextInt(looting + 1);
        }
        if (event.entityLiving instanceof EntityOcelot) {
            this.dropItems(event.entityLiving, itemCookedOcelot, itemRawOcelot, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntityHorse) {
            this.dropItems(event.entityLiving, itemCookedHorseRib, itemRawHorseRib, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntityEnderman) {
            this.dropItems(event.entityLiving, itemCookedEnder, itemRawEnder, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntityCreeper) {
            this.dropItems(event.entityLiving, (Item)itemCreeperGoo, (Item)itemCreeperGoo, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntitySheep) {
            if (this.rand.nextFloat() <= 0.3f) {
                this.dropItems(event.entityLiving, itemMintyLambBurger, itemRawLamb, 2 + lootingModifier);
            } else {
                this.dropItems(event.entityLiving, itemRawMutton, itemRawMutton, 2 + lootingModifier);
            }
        } else if (event.entityLiving instanceof EntitySpider) {
            this.dropItems(event.entityLiving, itemCookedSpiderLeg, itemRawSpiderLeg, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntitySquid) {
            this.dropItems(event.entityLiving, itemCookedSquid, itemRawSquid, 2 + lootingModifier);
        } else if (event.entityLiving instanceof EntityWolf) {
            this.dropItems(event.entityLiving, itemCookedWolf, itemRawWolf, 2 + lootingModifier);
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        World world = event.entity.field_70170_p;
        if (world instanceof WorldServer && event.entity instanceof EntityWolf) {
            WolfHandler.onJoinedWorld((EntityWolf)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        World world = event.entityLiving.field_70170_p;
        if (world instanceof WorldServer) {
            if (event.target instanceof EntityWolf) {
                WolfHandler.onInteract((EntityWolf)event.target, event.entityPlayer);
            } else if (event.target instanceof EntityOcelot) {
                OcelotHandler.onInteract((EntityOcelot)event.target, event.entityPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        World world = event.entityLiving.field_70170_p;
        if (world instanceof WorldServer && event.entityLiving instanceof EntityWolf) {
            WolfHandler.onUpdate((EntityWolf)event.entityLiving, world);
        }
    }

    private void dropItems(EntityLivingBase entity, Item cooked, Item raw, int max) {
        TileEntityMeatMachine machine;
        if (enableMeatMachine && (machine = blockMeatMachine.getCapturingMachine(entity)) != null) {
            Item item = raw;
            if (enableMeatMachineCooking) {
                item = cooked;
            }
            blockMeatMachine.addToInventory(machine, new ItemStack(item, max, 0));
            return;
        }
        int quantity = this.rand.nextInt(max + 1);
        for (int i = 0; i < quantity; ++i) {
            if (entity.func_70027_ad()) {
                entity.func_145779_a(cooked, 1);
                continue;
            }
            entity.func_145779_a(raw, 1);
        }
    }
}

