/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.moremeat;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import uk.co.stealthware.moremeat.MoreMeat2;
import uk.co.stealthware.moremeat.Packet;
import uk.co.stealthware.moremeat.block.BlockMeatMachine;
import uk.co.stealthware.moremeat.entity.CapturedEntity;
import uk.co.stealthware.moremeat.entity.TileEntityMeatMachine;

public class CommonProxy {
    public HashMap<EntityPlayer, Integer> explosions = new HashMap();

    public void registerRenderers() {
    }

    public void CheckEntity(BlockMeatMachine mm, World world, Entity entity, int x, int y, int z) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (world.func_72805_g(x, y, z) == 3) {
            return;
        }
        if (entity instanceof EntityLivingBase && !entity.field_70128_L && !this.AlreadyCaptured(mm, entity)) {
            if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            TileEntity meatMachine = world.func_147438_o(x, y, z);
            if (meatMachine != null && meatMachine instanceof TileEntityMeatMachine) {
                CapturedEntity captured = new CapturedEntity((EntityLivingBase)entity, (TileEntityMeatMachine)meatMachine);
                mm.capturedEntities.add(captured);
                this.sendCapturePacket(captured);
            }
        }
    }

    private boolean AlreadyCaptured(BlockMeatMachine mm, Entity entity) {
        for (CapturedEntity captured : mm.capturedEntities) {
            if (captured.getEntity() != entity) continue;
            return true;
        }
        return false;
    }

    public void updateMeatMachine(BlockMeatMachine mm) {
        if (mm.capturedEntities.size() > 0) {
            Object[] tempArray = new CapturedEntity[mm.capturedEntities.size()];
            mm.capturedEntities.copyInto(tempArray);
            for (Object captured : tempArray) {
                EntityLivingBase entity = ((CapturedEntity)captured).getEntity();
                TileEntityMeatMachine meatMachine = ((CapturedEntity)captured).getMeatMachine();
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                entity.field_70177_z += 30.0f;
                if (entity.func_110143_aJ() > 1.0f) {
                    entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
                    continue;
                }
                if (!(entity.func_110143_aJ() <= 1.0f) && !entity.field_70128_L) continue;
                entity.func_70606_j(0.0f);
                entity.func_70106_y();
                entity.func_70645_a(DamageSource.field_76377_j);
                if (entity instanceof EntityPlayerMP) {
                    mm.capturedEntities.remove(captured);
                    mm.LootPlayer((EntityPlayer)entity, meatMachine);
                }
                this.sendKillPacket((CapturedEntity)captured);
            }
        }
    }

    public void sendCapturePacket(CapturedEntity captured) {
        TileEntityMeatMachine mm = captured.getMeatMachine();
        Packet.CaptureEntity packet = new Packet.CaptureEntity();
        packet.position = new ChunkPosition(mm.field_145851_c, mm.field_145848_d, mm.field_145849_e);
        MoreMeat2.network.sendToAll((IMessage)packet);
    }

    public void sendKillPacket(CapturedEntity captured) {
        TileEntityMeatMachine mm = captured.getMeatMachine();
        Packet.KillEntity packet = new Packet.KillEntity();
        packet.position = new ChunkPosition(mm.field_145851_c, mm.field_145848_d, mm.field_145849_e);
        MoreMeat2.network.sendToAll((IMessage)packet);
    }

    public void sendTeleportEffectsPacket(EntityPlayer player, double oldX, double oldY, double oldZ) {
        Packet.TeleportEffects packet = new Packet.TeleportEffects();
        packet.oldX = oldX;
        packet.oldY = oldY;
        packet.oldZ = oldZ;
        packet.newX = player.field_70165_t;
        packet.newY = player.field_70163_u;
        packet.newZ = player.field_70161_v;
        packet.width = player.field_70130_N;
        packet.height = player.field_70131_O;
        MoreMeat2.network.sendToAll((IMessage)packet);
    }

    public void updateCreeperGoo() {
        if (this.explosions.size() == 0) {
            return;
        }
        Object[] array = this.explosions.entrySet().toArray();
        for (int i = 0; i < array.length; ++i) {
            Map.Entry item = (Map.Entry)array[i];
            if ((Integer)item.getValue() <= 0) {
                EntityPlayer player = (EntityPlayer)item.getKey();
                this.explosions.remove(player);
                player.field_70170_p.func_72876_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 3.0f, true);
                continue;
            }
            item.setValue((Integer)item.getValue() - 1);
        }
    }

    public void serverCapture(ChunkPosition pos) {
    }

    public void serverKill(ChunkPosition pos) {
    }

    public void doTeleportEffects(double oldX, double oldY, double oldZ, double newX, double newY, double newZ, double width, double height) {
    }

    public void fuseSound(double[] values2) {
    }
}

