/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.minecraft;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import uk.co.stealthware.minecraft.ModVersionChecker;

public abstract class StealthwareMod
implements IPlayerTracker {
    private boolean checkVersion;
    private ModVersionChecker mvc;

    protected StealthwareMod() {
    }

    protected void enableVersionCheck(Boolean checkVersion) {
        this.checkVersion = checkVersion;
        if (checkVersion.booleanValue()) {
            this.mvc = new ModVersionChecker(this);
        }
    }

    public void load(FMLInitializationEvent evt) {
        if (this.checkVersion) {
            this.mvc.load();
            GameRegistry.registerPlayerTracker((IPlayerTracker)this);
        }
    }

    public String getName() {
        return this.getClass().getAnnotation(Mod.class).modid();
    }

    public String getFriendlyName() {
        return this.getClass().getAnnotation(Mod.class).name();
    }

    public String getUrl() {
        return FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata().url;
    }

    public String getModVersion() {
        return this.getClass().getAnnotation(Mod.class).version();
    }

    public String getMinecraftVersion() {
        return "1.5.1";
    }

    public String getFullVersion() {
        return this.getModVersion() + " [" + this.getMinecraftVersion() + "]";
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (this.checkVersion) {
            this.mvc.check();
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }
}

