/*
 * Decompiled with CFR 0.152.
 */
package uk.co.stealthware.claysoil;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import uk.co.stealthware.minecraft.StealthwareMod;

@Mod(modid="ClaySoil", name="ClaySoil", version="1.4", useMetadata=true)
public class ClaySoil
extends StealthwareMod {
    public static boolean enableModVersionChecker = true;
    public static int clayDropChance = 15;
    public static int doubleChance = 30;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property prop = config.get("general", "Enable_ModVersionChecker", enableModVersionChecker);
        prop.comment = "true to enable automatic checking for new mod versions";
        enableModVersionChecker = prop.getBoolean(enableModVersionChecker);
        this.enableVersionCheck(enableModVersionChecker);
        prop = config.get("general", "ClayDropChance", clayDropChance);
        prop.comment = "The percentage chance of dropping Clay (valid range: 0-100)";
        clayDropChance = prop.getInt();
        if (clayDropChance < 0) {
            clayDropChance = 0;
        }
        if (clayDropChance > 100) {
            clayDropChance = 100;
        }
        prop = config.get("general", "DoubleChance", doubleChance);
        prop.comment = "The percentage chance of dropping 2 pieces instead of 1 (valid range: 0-100)";
        doubleChance = prop.getInt();
        if (doubleChance < 0) {
            doubleChance = 0;
        }
        if (doubleChance > 100) {
            doubleChance = 100;
        }
        config.save();
    }

    @Override
    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        super.load(evt);
    }

    public static void dropClay(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K || !world.func_82736_K().func_82766_b("doTileDrops") || player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (world.field_73012_v.nextFloat() <= (float)clayDropChance / 100.0f) {
            float f1 = 0.7f;
            float f2 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f3 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f4 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f2), (double)((float)y + f3), (double)((float)z + f4), new ItemStack(Item.field_77757_aI));
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
            if (world.field_73012_v.nextFloat() <= (float)doubleChance / 100.0f) {
                f2 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                f3 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                f4 = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                entityitem = new EntityItem(world, (double)((float)x + f2), (double)((float)y + f3), (double)((float)z + f4), new ItemStack(Item.field_77757_aI));
                entityitem.field_70293_c = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }
}

